/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.operators;

import com.android.jack.uncommons.maths.binary.BitString;
import com.android.jack.uncommons.maths.number.ConstantGenerator;
import com.android.jack.uncommons.maths.number.NumberGenerator;
import com.android.jack.uncommons.maths.random.Probability;
import com.android.jack.uncommons.watchmaker.framework.EvolutionaryOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BitStringMutation
implements EvolutionaryOperator<BitString> {
    private final NumberGenerator<Probability> mutationProbability;
    private final NumberGenerator<Integer> mutationCount;

    public BitStringMutation(Probability mutationProbability) {
        this(new ConstantGenerator<Probability>(mutationProbability), new ConstantGenerator<Integer>(1));
    }

    public BitStringMutation(NumberGenerator<Probability> mutationProbability, NumberGenerator<Integer> mutationCount) {
        this.mutationProbability = mutationProbability;
        this.mutationCount = mutationCount;
    }

    @Override
    public List<BitString> apply(List<BitString> selectedCandidates, Random rng) {
        ArrayList<BitString> mutatedPopulation = new ArrayList<BitString>(selectedCandidates.size());
        for (BitString b : selectedCandidates) {
            mutatedPopulation.add(this.mutateBitString(b, rng));
        }
        return mutatedPopulation;
    }

    private BitString mutateBitString(BitString bitString, Random rng) {
        if (this.mutationProbability.nextValue().nextEvent(rng)) {
            BitString mutatedBitString = bitString.clone();
            int mutations = this.mutationCount.nextValue();
            for (int i = 0; i < mutations; ++i) {
                mutatedBitString.flipBit(rng.nextInt(mutatedBitString.getLength()));
            }
            return mutatedBitString;
        }
        return bitString;
    }
}

