/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework;

import com.android.jack.uncommons.util.concurrent.ConfigurableThreadFactory;
import com.android.jack.uncommons.util.id.IDSource;
import com.android.jack.uncommons.util.id.IntSequenceIDSource;
import com.android.jack.uncommons.util.id.StringPrefixIDSource;
import com.android.jack.uncommons.watchmaker.framework.EvaluatedCandidate;
import com.android.jack.uncommons.watchmaker.framework.FitnessEvalutationTask;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FitnessEvaluationWorker {
    private static final IDSource<String> WORKER_ID_SOURCE = new StringPrefixIDSource("FitnessEvaluationWorker", new IntSequenceIDSource());
    private final LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue();
    private final ThreadPoolExecutor executor;

    FitnessEvaluationWorker() {
        this(true);
    }

    private FitnessEvaluationWorker(boolean daemonWorkerThreads) {
        ConfigurableThreadFactory threadFactory = new ConfigurableThreadFactory(WORKER_ID_SOURCE.nextID(), 5, daemonWorkerThreads);
        this.executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, this.workQueue, threadFactory);
        this.executor.prestartAllCoreThreads();
    }

    public <T> Future<EvaluatedCandidate<T>> submit(FitnessEvalutationTask<T> task) {
        return this.executor.submit(task);
    }

    public static void main(String[] args) {
        new FitnessEvaluationWorker(false);
    }

    protected void finalize() throws Throwable {
        this.executor.shutdown();
        super.finalize();
    }
}

