/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework;

import com.android.jack.uncommons.maths.statistics.DataSet;
import com.android.jack.uncommons.watchmaker.framework.EvaluatedCandidate;
import com.android.jack.uncommons.watchmaker.framework.PopulationData;
import com.android.jack.uncommons.watchmaker.framework.TerminationCondition;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class EvolutionUtils {
    private EvolutionUtils() {
    }

    public static <T> List<TerminationCondition> shouldContinue(PopulationData<T> data, TerminationCondition ... conditions) {
        if (Thread.currentThread().isInterrupted()) {
            return Collections.emptyList();
        }
        LinkedList<TerminationCondition> satisfiedConditions = new LinkedList<TerminationCondition>();
        for (TerminationCondition condition : conditions) {
            if (!condition.shouldTerminate(data)) continue;
            satisfiedConditions.add(condition);
        }
        return satisfiedConditions.isEmpty() ? null : satisfiedConditions;
    }

    public static <T> void sortEvaluatedPopulation(List<EvaluatedCandidate<T>> evaluatedPopulation, boolean naturalFitness) {
        if (naturalFitness) {
            Collections.sort(evaluatedPopulation, Collections.reverseOrder());
        } else {
            Collections.sort(evaluatedPopulation);
        }
    }

    public static <T> PopulationData<T> getPopulationData(List<EvaluatedCandidate<T>> evaluatedPopulation, boolean naturalFitness, int eliteCount, int iterationNumber, long startTime) {
        DataSet stats = new DataSet(evaluatedPopulation.size());
        for (EvaluatedCandidate<T> candidate : evaluatedPopulation) {
            stats.addValue(candidate.getFitness());
        }
        return new PopulationData<T>(evaluatedPopulation.get(0).getCandidate(), evaluatedPopulation.get(0).getFitness(), stats.getArithmeticMean(), stats.getStandardDeviation(), naturalFitness, stats.getSize(), eliteCount, iterationNumber, System.currentTimeMillis() - startTime);
    }
}

