/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.util.id;

import com.android.jack.uncommons.util.id.IDSource;
import com.android.jack.uncommons.util.id.IDSourceExhaustedException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class LongSequenceIDSource
implements IDSource<Long> {
    private static final int SECONDS_IN_DAY = 86400;
    private final Lock lock = new ReentrantLock();
    private final long startTime;
    private long lastID = -1L;

    public LongSequenceIDSource(long firstValue) {
        if (firstValue < 0L) {
            throw new IllegalArgumentException("Initial value must be non-negative.");
        }
        this.lastID = firstValue - 1L;
        this.startTime = System.currentTimeMillis();
    }

    public LongSequenceIDSource() {
        this(0L);
    }

    @Override
    public Long nextID() {
        this.lock.lock();
        try {
            if (this.lastID == Long.MAX_VALUE) {
                long days = (System.currentTimeMillis() - this.startTime) / 86400L;
                throw new IDSourceExhaustedException("64-bit ID source exhausted after " + days + " days.");
            }
            ++this.lastID;
            Long l = this.lastID;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }
}

