/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.maths.random;

import com.android.jack.uncommons.maths.number.ConstantGenerator;
import com.android.jack.uncommons.maths.number.NumberGenerator;
import java.util.Random;

public class ExponentialGenerator
implements NumberGenerator<Double> {
    private final NumberGenerator<Double> rate;
    private final Random rng;

    public ExponentialGenerator(NumberGenerator<Double> rate, Random rng) {
        this.rate = rate;
        this.rng = rng;
    }

    public ExponentialGenerator(double rate, Random rng) {
        this(new ConstantGenerator<Double>(rate), rng);
    }

    @Override
    public Double nextValue() {
        double u;
        while ((u = this.rng.nextDouble()) == 0.0) {
        }
        return -Math.log(u) / this.rate.nextValue();
    }
}

