/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.uselessif;

import com.android.jack.Options;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import javax.annotation.Nonnull;

@Description(value="Removes useless if statement")
@Constraint(need={JIfStatement.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class UselessIfRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    public static final StatisticId<Counter> REMOVED_IF = new StatisticId<Counter>("jack.statement.if.removed", "Removed 'if' statement", CounterImpl.class, Counter.class);
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest request = new TransformationRequest(method);
        UselessIfRemoverVisitor visitor = new UselessIfRemoverVisitor(request);
        visitor.accept(method);
        request.commit();
    }

    private class UselessIfRemoverVisitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest request;

        private UselessIfRemoverVisitor(TransformationRequest request) {
            this.request = request;
        }

        @Override
        public boolean visit(@Nonnull JIfStatement ifStmt) {
            if (ifStmt.getIfExpr() instanceof JBooleanLiteral) {
                JBooleanLiteral cond = (JBooleanLiteral)ifStmt.getIfExpr();
                UselessIfRemover.this.tracer.getStatistic(REMOVED_IF).incValue();
                if (cond.getValue()) {
                    JStatement thenStmt = ifStmt.getThenStmt();
                    if (thenStmt != null) {
                        this.request.append(new Replace(ifStmt, thenStmt));
                    } else {
                        this.request.append(new Remove(ifStmt));
                    }
                } else {
                    JStatement elseStmt = ifStmt.getElseStmt();
                    if (elseStmt != null) {
                        this.request.append(new Replace(ifStmt, elseStmt));
                    } else {
                        this.request.append(new Remove(ifStmt));
                    }
                }
            }
            return super.visit(ifStmt);
        }
    }
}

