/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.threeaddresscode;

import com.android.jack.Options;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBinaryOperator;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.transformations.SanityChecks;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Check that tyhe code is in three address form.")
@Name(value="ThreeAddressCodeChecker")
@Constraint(need={ThreeAddressCodeForm.class})
@Transform(add={ThreeAddressCodeForm.Checked.class})
@Support(value={SanityChecks.class})
public class ThreeAddressCodeChecker
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        InternalThreeAddressCodeChecker tcaBuilder = new InternalThreeAddressCodeChecker();
        tcaBuilder.accept(method);
    }

    private static class InternalThreeAddressCodeChecker
    extends JVisitor {
        private InternalThreeAddressCodeChecker() {
        }

        @Override
        public boolean visit(@Nonnull JExpression expr) {
            if (expr.getParent() instanceof JExpression) {
                InternalThreeAddressCodeChecker.throwError(expr);
            }
            if (expr.getParent() instanceof JIfStatement && !this.isValidExpressionForTac(expr)) {
                InternalThreeAddressCodeChecker.throwError(expr);
            }
            if (expr instanceof JBinaryOperation) {
                JBinaryOperation binary = (JBinaryOperation)expr;
                if (!this.isVariableRef(binary.getLhs()) || !this.isValidExpressionForTac(binary.getRhs())) {
                    InternalThreeAddressCodeChecker.throwError(expr);
                }
                return false;
            }
            return super.visit(expr);
        }

        private static void throwError(@Nonnull JExpression expr) {
            throw new AssertionError((Object)(expr.getParent().toSource() + " is not three address code."));
        }

        private boolean isValidExpressionForTac(@Nonnull JExpression expr) {
            if (this.isVariableRef(expr) || expr instanceof JLiteral) {
                return true;
            }
            if (expr instanceof JBinaryOperation) {
                JBinaryOperation binary = (JBinaryOperation)expr;
                if (binary.getOp() == JBinaryOperator.ASG) {
                    return false;
                }
                return this.isVariableRef(binary.getLhs()) && this.isVariableRef(binary.getRhs());
            }
            if (expr instanceof JArrayRef) {
                JArrayRef arrayRef = (JArrayRef)expr;
                return this.isVariableRef(arrayRef.getInstance()) && this.isVariableRef(arrayRef.getIndexExpr());
            }
            if (expr instanceof JMethodCall) {
                JMethodCall methodCall = (JMethodCall)expr;
                JExpression instance = methodCall.getInstance();
                if (instance != null && !this.isVariableRef(instance)) {
                    return false;
                }
                for (JExpression param : methodCall.getArgs()) {
                    if (this.isVariableRef(param)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean isVariableRef(@Nonnull JExpression expr) {
            return expr instanceof JLocalRef || expr instanceof JParameterRef;
        }
    }
}

