/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.request;

import com.android.jack.Jack;
import com.android.jack.ir.ast.HasEnclosingPackage;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JSession;
import com.android.jack.transformations.request.TransformationStep;
import com.android.sched.transform.TransformStep;
import javax.annotation.Nonnull;

public class ChangeEnclosingPackage
implements TransformationStep,
TransformStep {
    @Nonnull
    private final JPackage newEnclosingPackage;
    @Nonnull
    private final HasEnclosingPackage existingNode;
    @Nonnull
    private final JSession session = Jack.getSession();

    public ChangeEnclosingPackage(@Nonnull HasEnclosingPackage existingNode, @Nonnull JPackage newEnclosingPackage) {
        assert (existingNode != this.session.getTopLevelPackage()) : "The default package can't change its enclosing package";
        this.newEnclosingPackage = newEnclosingPackage;
        this.existingNode = existingNode;
    }

    @Override
    public void apply() throws UnsupportedOperationException {
        JPackage enclosingPackage = this.existingNode.getEnclosingPackage();
        if (enclosingPackage != null) {
            enclosingPackage.remove((JNode)((Object)this.existingNode));
        }
        this.newEnclosingPackage.add(this.existingNode);
        this.existingNode.setEnclosingPackage(this.newEnclosingPackage);
        ((JNode)((Object)this.existingNode)).updateParents(this.newEnclosingPackage);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder("Change enclosing package of ");
        sb.append(this.existingNode.toString());
        sb.append(" to ");
        sb.append(Jack.getUserFriendlyFormatter().getName(this.newEnclosingPackage));
        return sb.toString();
    }
}

