/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.lambda;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.formatter.TypeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;

final class LambdaInterfaceSignature {
    @Nonnull
    private static final TypeFormatter FORMATTER = Jack.getLookupFormatter();
    @Nonnull
    private final String allInterfaces;

    private LambdaInterfaceSignature(@Nonnull JLambda lambda, boolean normalize) {
        StringBuilder sb = new StringBuilder();
        List<JInterface> interfaces = LambdaInterfaceSignature.extractOrderedInterfaces(lambda);
        if (normalize) {
            for (String key : LambdaInterfaceSignature.getNormalizedInterfacesMap(interfaces).keySet()) {
                sb.append(key);
            }
        } else {
            for (JInterface inter : interfaces) {
                sb.append(FORMATTER.getName(inter));
            }
        }
        this.allInterfaces = sb.toString();
    }

    @Nonnull
    static LambdaInterfaceSignature forLambda(@Nonnull JLambda lambda, boolean normalize) {
        return new LambdaInterfaceSignature(lambda, normalize);
    }

    @Nonnull
    String getUniqueId() {
        return this.allInterfaces;
    }

    @Nonnull
    static List<JInterface> extractOrderedInterfaces(@Nonnull JLambda lambda) {
        ArrayList<JInterface> interfaces = new ArrayList<JInterface>();
        JInterface mainInterface = lambda.getType();
        interfaces.add(mainInterface);
        for (JInterface bound : lambda.getInterfaceBounds()) {
            if (bound.isSameType(mainInterface)) continue;
            interfaces.add(bound);
        }
        return interfaces;
    }

    @Nonnull
    static List<JInterface> normalizeInterfaces(@Nonnull List<JLambda> lambdas) {
        ArrayList<JInterface> interfaces = new ArrayList<JInterface>();
        for (JLambda lambda : lambdas) {
            interfaces.addAll(LambdaInterfaceSignature.extractOrderedInterfaces(lambda));
        }
        return new ArrayList<JInterface>(LambdaInterfaceSignature.getNormalizedInterfacesMap(interfaces).values());
    }

    @Nonnull
    private static TreeMap<String, JInterface> getNormalizedInterfacesMap(@Nonnull List<JInterface> interfaces) {
        HashSet<String> hidden = new HashSet<String>();
        TreeMap<String, JInterface> map = new TreeMap<String, JInterface>();
        for (JInterface inter : interfaces) {
            map.put(LambdaInterfaceSignature.collectHiddenInterfaces(hidden, inter, true), inter);
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!hidden.contains(iterator.next().getKey())) continue;
            iterator.remove();
        }
        return map;
    }

    @Nonnull
    private static String collectHiddenInterfaces(@Nonnull Set<String> hidden, @Nonnull JInterface inter, boolean isTopLevel) {
        String signature = FORMATTER.getName(inter);
        if (hidden.contains(signature)) {
            if (inter instanceof JDefinedInterface) {
                for (JInterface implemented : ((JDefinedInterface)inter).getImplements()) {
                    LambdaInterfaceSignature.collectHiddenInterfaces(hidden, implemented, false);
                }
            }
            if (!isTopLevel) {
                hidden.add(signature);
            }
        }
        return signature;
    }
}

