/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.lambda;

import com.android.jack.ir.ast.JByteLiteral;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JShortLiteral;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.ir.types.JIntegralType32;
import com.android.jack.transformations.ast.NewInstanceRemoved;
import com.android.jack.transformations.request.AppendArgument;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import com.android.sched.schedulable.Transform;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Represents information about mapping of a lambda into lambda group class")
@ValidOn(value={JLambda.class})
@Transform(add={JByteLiteral.class, JIntLiteral.class, JNewInstance.class, JShortLiteral.class}, remove={NewInstanceRemoved.class})
final class LambdaInfoMarker
implements Marker {
    static final int NO_LAMBDA_ID = -1;
    @Nonnull
    private final JDefinedClass groupClass;
    @CheckForNull
    private final JField instanceField;
    private int lambdaId;
    @Nonnull
    private int[] captureMapping;

    LambdaInfoMarker(@Nonnull JDefinedClass groupClass, @CheckForNull JField instanceField, int lambdaId, @Nonnull int[] captureMapping) {
        this.groupClass = groupClass;
        this.instanceField = instanceField;
        this.lambdaId = lambdaId;
        this.captureMapping = captureMapping;
    }

    boolean hasId() {
        return this.lambdaId != -1;
    }

    @Nonnegative
    public int getId() {
        assert (this.hasId());
        return this.lambdaId;
    }

    boolean hasInstanceField() {
        return this.instanceField != null;
    }

    @Nonnull
    JField getInstanceField() {
        assert (this.instanceField != null);
        return this.instanceField;
    }

    @Nonnull
    int[] getCaptureMapping() {
        return this.captureMapping;
    }

    @Nonnull
    JNewInstance createGroupClassInstance(@Nonnull TransformationRequest request, @Nonnull List<JExpression> origArgs, @Nonnull SourceInfo origSourceInfo) {
        return this.createGroupClassInstance(request, this.getGroupClassConstructor(), origArgs, origSourceInfo);
    }

    @Nonnull
    private JConstructor getGroupClassConstructor() {
        for (JMethod method : this.groupClass.getMethods()) {
            if (!(method instanceof JConstructor)) continue;
            return (JConstructor)method;
        }
        throw new AssertionError();
    }

    @Nonnull
    JNewInstance createGroupClassInstance(@Nonnull TransformationRequest request, @Nonnull JConstructor constructor, @Nonnull List<JExpression> args, @Nonnull SourceInfo sourceInfo) {
        JMethodIdWide constructorIdWide = constructor.getMethodIdWide();
        List<JType> paramTypes = constructorIdWide.getParamTypes();
        JExpression[] newArgs = new JExpression[paramTypes.size()];
        int offset = 0;
        if (this.hasId()) {
            assert (paramTypes.size() > 0);
            JIntegralType32 idType = (JIntegralType32)((Object)paramTypes.get(0));
            newArgs[0] = idType.createLiteral(SourceInfo.UNKNOWN, this.getId());
            offset = 1;
        }
        int size = args.size();
        assert (newArgs.length == size + offset);
        int[] mapping = this.getCaptureMapping();
        assert (size == mapping.length);
        for (int i = 0; i < size; ++i) {
            int newIdx = mapping[i] + offset;
            assert (newIdx < newArgs.length && newArgs[newIdx] == null);
            newArgs[newIdx] = args.get(i);
        }
        JNewInstance newNode = new JNewInstance(sourceInfo, this.groupClass, constructorIdWide);
        for (JExpression newArg : newArgs) {
            assert (newArg != null);
            request.append(new AppendArgument(newNode, newArg));
        }
        return newNode;
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        throw new AssertionError();
    }
}

