/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.lambda;

import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.util.NamingTools;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

final class LambdaCaptureSignature {
    @Nonnegative
    private static final int R_INDEX = JPrimitiveType.JPrimitiveTypeEnum.VOID.ordinal();
    @Nonnull
    private final int[] tuple;

    private LambdaCaptureSignature(@Nonnull int[] tuple) {
        this.tuple = tuple;
    }

    @Nonnull
    static LambdaCaptureSignature forLambda(@Nonnull JLambda lambda) {
        int[] tuple = new int[JPrimitiveType.JPrimitiveTypeEnum.values().length];
        for (JExpression capture : lambda.getCapturedVariables()) {
            JType fieldType = capture.getType();
            if (fieldType instanceof JPrimitiveType) {
                int index;
                int n = index = ((JPrimitiveType)fieldType).getPrimitiveTypeEnum().ordinal();
                tuple[n] = tuple[n] + 1;
                continue;
            }
            int n = R_INDEX;
            tuple[n] = tuple[n] + 1;
        }
        return new LambdaCaptureSignature(tuple);
    }

    @Nonnull
    int[] createMapping(@Nonnull JLambda lambda) {
        int length = this.tuple.length;
        int[] indices = new int[length];
        for (int i = 1; i < length; ++i) {
            indices[i] = indices[i - 1] + this.tuple[i - 1];
        }
        List<JExpression> vars = lambda.getCapturedVariables();
        assert (vars.size() == indices[length - 1] + this.tuple[length - 1]);
        int[] result = new int[vars.size()];
        for (int k = 0; k < vars.size(); ++k) {
            JType fieldType = vars.get(k).getType();
            if (fieldType instanceof JPrimitiveType) {
                int index;
                int n = index = ((JPrimitiveType)fieldType).getPrimitiveTypeEnum().ordinal();
                indices[n] = indices[n] + 1;
                continue;
            }
            int n = R_INDEX;
            indices[n] = indices[n] + 1;
        }
        return result;
    }

    @Nonnull
    List<JField> createFields(@Nonnull JDefinedClass clazz, @Nonnull JType objType) {
        ArrayList<JField> fields = new ArrayList<JField>();
        JPrimitiveType.JPrimitiveTypeEnum[] primitiveTypes = JPrimitiveType.JPrimitiveTypeEnum.values();
        for (int i = 0; i < this.tuple.length; ++i) {
            JType fieldType = i == R_INDEX ? objType : primitiveTypes[i].getType();
            this.addFields(this.tuple[i], clazz, fieldType, fields);
        }
        return fields;
    }

    private void addFields(@Nonnegative int count, @Nonnull JDefinedClass clazz, @Nonnull JType type, @Nonnull List<JField> fields) {
        for (int i = 0; i < count; ++i) {
            fields.add(new JField(SourceInfo.UNKNOWN, NamingTools.getNonSourceConflictingName("$f" + fields.size()), clazz, type, 4114));
        }
    }

    @Nonnull
    String getUniqueId() {
        StringBuilder builder = new StringBuilder();
        for (int element : this.tuple) {
            builder.append(Integer.toString(element, 16)).append(';');
        }
        return builder.toString();
    }
}

