/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.enums.opt;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.enums.opt.EnumFieldMarker;
import com.android.jack.transformations.enums.opt.SwitchEnumUsageMarker;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import javax.annotation.Nonnull;

@Description(value="Collect the number of classes using each enum in switch statements.")
@Name(value="SwitchEnumUsageCollector")
@Constraint(need={JSwitchStatement.class, JDefinedClass.class, JDefinedEnum.class})
@Filter(value={SourceTypeFilter.class})
@Transform(add={SwitchEnumUsageMarker.class, EnumFieldMarker.class})
@Access(value=JSession.class)
public class SwitchEnumUsageCollector
implements RunnableSchedulable<JMethod> {
    @Nonnull
    public static final StatisticId<Counter> SYNTHETIC_SWITCHMAP_METHOD = new StatisticId<Counter>("jack.optimization.enum.switch.synthetic.method.decrease", "Total number of synthetic method eliminated", CounterImpl.class, Counter.class);
    @Nonnull
    private final Tracer statisticTracer = TracerFactory.getTracer();

    @Override
    public void run(@Nonnull JMethod method) {
        JDefinedClassOrInterface definedClass = method.getEnclosingType();
        if (!(definedClass instanceof JDefinedClass) || method.isNative() || method.isAbstract()) {
            return;
        }
        Visitor visitor = new Visitor((JDefinedClass)definedClass);
        visitor.accept(method);
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final JDefinedClass enclosingClass;

        public Visitor(JDefinedClass enclosingClass) {
            this.enclosingClass = enclosingClass;
        }

        @Override
        public boolean visit(@Nonnull JSwitchStatement switchStmt) {
            JExpression switchExpr = switchStmt.getExpr();
            JType switchExprType = switchExpr.getType();
            if (switchExprType instanceof JDefinedEnum) {
                SwitchEnumUsageMarker newMarker;
                JDefinedEnum enumType = (JDefinedEnum)switchExprType;
                JPackage enclosingPackage = enumType.isPublic() ? Jack.getSession().getLookup().getOrCreatePackage("com/android/jack/enums/synthetic") : enumType.getEnclosingPackage();
                SwitchEnumUsageMarker usageMarker = enclosingPackage.getMarker(SwitchEnumUsageMarker.class);
                if (usageMarker == null && (usageMarker = enclosingPackage.addMarkerIfAbsent(newMarker = new SwitchEnumUsageMarker(enclosingPackage))) == null) {
                    usageMarker = newMarker;
                }
                if (usageMarker.addEnumUsage(this.enclosingClass, enumType) && usageMarker.getUses() > 1) {
                    SwitchEnumUsageCollector.this.statisticTracer.getStatistic(SYNTHETIC_SWITCHMAP_METHOD).incValue();
                }
            }
            return super.visit(switchStmt);
        }
    }
}

