/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.enums.opt;

import com.android.jack.google.common.collect.Lists;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JEnumField;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="A marker which records the enum fields related to an enum.")
@ValidOn(value={JDefinedEnum.class})
public final class EnumFieldMarker
implements Marker {
    @Nonnull
    private final List<JEnumField> enumFields = Lists.newArrayList();
    private boolean areFieldsSorted = false;

    public void addEnumField(@Nonnull JEnumField enumField) {
        assert (!this.enumFields.contains(enumField));
        this.enumFields.add(enumField);
        this.areFieldsSorted = false;
    }

    public void sortEnumFields() {
        if (!this.areFieldsSorted) {
            Collections.sort(this.enumFields, new Comparator<JEnumField>(){

                @Override
                public int compare(JEnumField field1, JEnumField field2) {
                    return field1.getName().compareTo(field2.getName());
                }
            });
            this.areFieldsSorted = true;
        }
    }

    @Nonnull
    public List<JEnumField> getEnumFields() {
        return this.enumFields;
    }

    @Override
    public Marker cloneIfNeeded() {
        return this;
    }
}

