/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.enums;

import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JEnumLiteral;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.enums.SwitchEnumSupport;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

@Description(value="Collect all enum fields used into a switch")
@Constraint(need={JSwitchStatement.SwitchWithEnum.class})
@Transform(add={SwitchEnumSupport.UsedEnumField.class})
@Filter(value={SourceTypeFilter.class})
public class UsedEnumFieldCollector
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Override
    public void run(@Nonnull JDefinedClassOrInterface declaredType) {
        Collector c = new Collector();
        c.accept(declaredType);
    }

    private static class Collector
    extends JVisitor {
        @Nonnull
        private final Set<JFieldId> usedEnumField = new HashSet<JFieldId>();

        private Collector() {
        }

        @Override
        public void endVisit(@Nonnull JDefinedClassOrInterface clOrI) {
            clOrI.addMarker(new SwitchEnumSupport.UsedEnumField(this.usedEnumField));
            super.endVisit(clOrI);
        }

        @Override
        public boolean visit(@Nonnull JCaseStatement caseStmt) {
            JLiteral caseExpr = caseStmt.getExpr();
            if (caseExpr != null && caseExpr instanceof JEnumLiteral) {
                this.usedEnumField.add(((JEnumLiteral)caseExpr).getFieldId());
            }
            return super.visit(caseStmt);
        }
    }
}

