/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.debug;

import com.android.jack.Options;
import com.android.jack.ir.JavaSourceIr;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Feature;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Sets parameter debug info to method debug info, and expression debug info to statement debug info")
@Name(value="DebugInfoNormalizer")
@Constraint(need={JavaSourceIr.class})
@Support(value={DebugInfoNormalizer.class})
public class DebugInfoNormalizer
implements RunnableSchedulable<JMethod>,
Feature {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Visitor visitor = new Visitor();
        visitor.accept(method);
    }

    private static class Visitor
    extends JVisitor {
        @CheckForNull
        private SourceInfo currentInfo;

        @Override
        public boolean visit(@Nonnull JMethod x) {
            this.currentInfo = x.getSourceInfo();
            return super.visit(x);
        }

        @Override
        public boolean visit(@Nonnull JParameter x) {
            assert (this.currentInfo != null);
            x.setSourceInfo(this.currentInfo);
            return super.visit(x);
        }

        @Override
        public boolean visit(@Nonnull JStatement x) {
            this.currentInfo = x.getSourceInfo();
            return super.visit(x);
        }

        @Override
        public boolean visit(@Nonnull JExpression x) {
            assert (this.currentInfo != null);
            x.setSourceInfo(this.currentInfo);
            return super.visit(x);
        }
    }
}

