/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.string.parameterrefiners;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JStringLiteral;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.BinarySignatureFormatter;
import com.android.jack.ir.formatter.TypeFormatter;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JLookup;
import com.android.jack.lookup.JPhantomLookup;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

abstract class CommonStringParameterRefiner {
    @Nonnull
    protected final JClass javaLangClass;
    @Nonnull
    protected final JClass javaLangString;
    @Nonnull
    protected final JType javaLangClassArray;
    @Nonnull
    protected final JLookup lookup = Jack.getSession().getLookup();
    @Nonnull
    protected static final String FIELD_CLASS_SIGNATURE = "Ljava/lang/reflect/Field;";
    @Nonnull
    protected static final String METHOD_CLASS_SIGNATURE = "Ljava/lang/reflect/Method;";
    @Nonnull
    protected static final String NEWUPDATER_METHOD_NAME = "newUpdater";
    @Nonnull
    protected static final TypeFormatter formatter = BinarySignatureFormatter.getFormatter();

    CommonStringParameterRefiner() {
        JPhantomLookup phantomLookup = Jack.getSession().getPhantomLookup();
        this.javaLangClass = phantomLookup.getClass(CommonTypes.JAVA_LANG_CLASS);
        this.javaLangString = phantomLookup.getClass(CommonTypes.JAVA_LANG_STRING);
        this.javaLangClassArray = this.javaLangClass.getArray();
    }

    @CheckForNull
    protected JStringLiteral getExpressionToRefine(@Nonnull JMethodCall call, @Nonnegative int paramIndex) {
        assert (paramIndex >= 0 && paramIndex < call.getArgs().size());
        JExpression arg = call.getArgs().get(paramIndex);
        if (arg instanceof JStringLiteral) {
            return (JStringLiteral)arg;
        }
        return null;
    }

    @CheckForNull
    protected JDefinedClassOrInterface getTypeFromClassLiteralExpression(@CheckForNull JExpression expr) {
        JType type;
        if (expr != null && expr instanceof JClassLiteral && (type = ((JClassLiteral)expr).getRefType()) instanceof JDefinedClassOrInterface) {
            return (JDefinedClassOrInterface)type;
        }
        return null;
    }

    protected boolean isOrIsSubClassOf(@Nonnull JClassOrInterface rootType, @Nonnull JReferenceType searchedType) {
        if (rootType.isSameType(searchedType)) {
            return true;
        }
        if (rootType instanceof JDefinedClass) {
            return ((JDefinedClass)rootType).isSubTypeOf(searchedType);
        }
        return false;
    }
}

