/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.string;

import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.marker.GenericSignature;
import com.android.jack.signature.GenericSignatureParser;
import com.android.jack.transformations.ast.string.GenericSignatureRefiner;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import javax.annotation.Nonnull;

@Description(value="Split field generic signature into more specific string literals.")
@Name(value="FieldGenericSignatureSplitter")
@Transform(modify={GenericSignature.class})
@Use(value={GenericSignatureRefiner.class})
public class FieldGenericSignatureSplitter
implements RunnableSchedulable<JField> {
    @Override
    public void run(@Nonnull JField field) {
        GenericSignature marker = field.getMarker(GenericSignature.class);
        if (marker != null) {
            String oldSignature = marker.getGenericSignature();
            GenericSignatureRefiner parserActions = new GenericSignatureRefiner();
            GenericSignatureParser<JType> parser = new GenericSignatureParser<JType>(parserActions);
            parser.parseFieldSignature(oldSignature);
            assert (parserActions.getNewSignature().toString().equals(oldSignature));
            marker.setGenericSignature(parserActions.getNewSignature());
        }
    }
}

