/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.splitnew;

import com.android.jack.Options;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.SanityChecks;
import com.android.jack.transformations.ast.NewInstanceRemoved;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Checkes that all occurrences of JSymbolicNewInstance have been removed.")
@Name(value="SplitNewInstanceChecker")
@Constraint(no={JNewInstance.class}, need={NewInstanceRemoved.class})
@Support(value={SanityChecks.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class SplitNewInstanceChecker
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Visitor visitor = new Visitor();
        visitor.accept(method);
    }

    private static class Visitor
    extends JVisitor {
        private Visitor() {
        }

        @Override
        public boolean visit(@Nonnull JNewInstance newInstance) {
            throw new AssertionError((Object)"All JSymbolicNewInstance occurences should have been removed");
        }
    }
}

