/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Options;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMultiExpression;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.ast.InitInNewArray;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Remove non-constant initializers from JNewArray.")
@Name(value="InitInNewArrayRemover")
@Constraint(need={InitInNewArray.class, JNewArray.class})
@Transform(remove={InitInNewArray.class, ThreeAddressCodeForm.class}, add={JMultiExpression.class, JIntLiteral.class, JAsgOperation.NonReusedAsg.class, JLocalRef.class, JNewArray.class, JArrayRef.class})
@Use(value={LocalVarCreator.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class InitInNewArrayRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        Visitor visitor = new Visitor(tr, new LocalVarCreator(method, "iinar"));
        visitor.accept(method);
        tr.commit();
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;
        @Nonnull
        private final LocalVarCreator lvCreator;

        public Visitor(@Nonnull TransformationRequest tr, @Nonnull LocalVarCreator lvCreator) {
            this.tr = tr;
            this.lvCreator = lvCreator;
        }

        @Override
        public boolean visit(@Nonnull JNewArray newArray) {
            List<JExpression> initializers = newArray.getInitializers();
            if (!(initializers.isEmpty() || newArray.hasConstantInitializer() && initializers.size() != 1)) {
                ArrayList<JExpression> expressions = new ArrayList<JExpression>(1 + initializers.size() + 1);
                SourceInfo sourceInfo = newArray.getSourceInfo();
                JArrayType expressionType = newArray.getType();
                JLocal array = this.lvCreator.createTempLocal(expressionType, sourceInfo, this.tr);
                ArrayList<JExpression> dims = new ArrayList<JExpression>(1);
                dims.add(new JIntLiteral(sourceInfo, initializers.size()));
                expressions.add(new JAsgOperation(sourceInfo, array.makeRef(sourceInfo), JNewArray.createWithDims(sourceInfo, newArray.getArrayType(), dims)));
                int index = 0;
                for (JExpression expression : initializers) {
                    SourceInfo expressionInfo = expression.getSourceInfo();
                    expressions.add(new JAsgOperation(expressionInfo, new JArrayRef(expressionInfo, array.makeRef(sourceInfo), new JIntLiteral(expressionInfo, index)), expression));
                    ++index;
                }
                expressions.add(array.makeRef(sourceInfo));
                this.tr.append(new Replace(newArray, new JMultiExpression(sourceInfo, expressions)));
            }
            return super.visit(newArray);
        }
    }
}

