/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Options;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JConditionalExpression;
import com.android.jack.ir.ast.JConditionalOperation;
import com.android.jack.ir.ast.JEqOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JLoop;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.BooleanTestOutsideIf;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="transforms boolean tests that are not in the condition expressionof an \"if\" statement into a JConditional")
@Transform(add={JConditionalExpression.class, JBooleanLiteral.class, JEqOperation.class}, remove={BooleanTestOutsideIf.class, ThreeAddressCodeForm.class})
@Constraint(no={JConditionalOperation.class, JLoop.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class BooleanTestTransformer
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Visitor visitor = new Visitor(method);
        visitor.accept(method);
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final JMethod method;

        public Visitor(@Nonnull JMethod method) {
            this.method = method;
        }

        @Override
        public void endVisit(@Nonnull JBinaryOperation binOp) {
            switch (binOp.getOp()) {
                case EQ: 
                case NEQ: 
                case GTE: 
                case GT: 
                case LTE: 
                case LT: {
                    if (!this.needReplacement(binOp)) break;
                    SourceInfo sourceInfo = binOp.getSourceInfo();
                    JConditionalExpression replacingExpr = new JConditionalExpression(sourceInfo, binOp, new JBooleanLiteral(sourceInfo, true), new JBooleanLiteral(sourceInfo, false));
                    TransformationRequest request = new TransformationRequest(this.method);
                    request.append(new Replace(binOp, replacingExpr));
                    request.commit();
                    break;
                }
            }
            super.endVisit(binOp);
        }

        private boolean needReplacement(@Nonnull JBinaryOperation binOp) {
            return !this.isIfCondition(binOp) && !this.isConditionalCondition(binOp);
        }

        private boolean isIfCondition(@Nonnull JExpression expr) {
            JNode parent = expr.getParent();
            return parent instanceof JIfStatement && ((JIfStatement)parent).getIfExpr() == expr;
        }

        private boolean isConditionalCondition(@Nonnull JExpression expr) {
            JNode parent = expr.getParent();
            return parent instanceof JConditionalExpression && ((JConditionalExpression)parent).getIfTest() == expr;
        }
    }
}

