/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.annotation;

import com.android.jack.Jack;
import com.android.jack.ir.ast.Annotable;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JDefinedAnnotationType;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JSession;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.annotation.ContainerAnnotationMarker;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import java.util.Collection;
import javax.annotation.Nonnull;

@Transform(add={ContainerAnnotationMarker.class})
@Access(value=JSession.class)
public class ContainerAnnotationMarkerAdder {
    @Nonnull
    private final JAnnotationType repeatableAnnotationType = Jack.getSession().getPhantomLookup().getAnnotationType("Ljava/lang/annotation/Repeatable;");

    protected void addContainerAnnotationIfNeeded(@Nonnull Annotable annotable) {
        for (JAnnotationType annotationType : annotable.getAnnotationTypes()) {
            Collection<JAnnotation> annotationsOfSameType = annotable.getAnnotations(annotationType);
            if (annotationsOfSameType.size() <= 1) continue;
            Collection repeatableAnnotation = ((JDefinedAnnotationType)annotationType).getAnnotations(this.repeatableAnnotationType);
            assert (repeatableAnnotation.size() == 1);
            JNameValuePair jnvp = ((JAnnotation)repeatableAnnotation.get(0)).getNameValuePair("value");
            assert (jnvp != null);
            JClassLiteral containerLiteral = (JClassLiteral)jnvp.getValue();
            JAnnotationType containerAnnotationType = (JAnnotationType)containerLiteral.getRefType();
            ContainerAnnotationMarker cam = new ContainerAnnotationMarker(containerAnnotationType, ((JDefinedAnnotationType)containerAnnotationType).getRetentionPolicy());
            for (JAnnotation annotation : annotationsOfSameType) {
                annotation.addMarker(cam);
            }
        }
    }

    @Description(value="Add a container annotation marker when annotations with the same annotations type are on the same method or parameter")
    @Constraint(need={JAnnotation.RepeatedAnnotationOnMethod.class})
    @Use(value={ContainerAnnotationMarkerAdder.class})
    @Access(value=JSession.class)
    @Filter(value={SourceTypeFilter.class})
    public static class MethodContainerAnnotationMarkerAdder
    extends ContainerAnnotationMarkerAdder
    implements RunnableSchedulable<JMethod> {
        @Override
        public void run(@Nonnull JMethod jMethod) {
            this.addContainerAnnotationIfNeeded(jMethod);
            for (JParameter parameter : jMethod.getParams()) {
                this.addContainerAnnotationIfNeeded(parameter);
            }
        }
    }

    @Description(value="Add a container annotation marker when annotations with the same annotations type are on the same field")
    @Constraint(need={JAnnotation.RepeatedAnnotationOnField.class})
    @Use(value={ContainerAnnotationMarkerAdder.class})
    @Access(value=JSession.class)
    @Filter(value={SourceTypeFilter.class})
    public static class FieldContainerAnnotationMarkerAdder
    extends ContainerAnnotationMarkerAdder
    implements RunnableSchedulable<JField> {
        @Override
        public void run(@Nonnull JField type) {
            this.addContainerAnnotationIfNeeded(type);
        }
    }

    @Description(value="Add a container annotation marker when annotations with the same annotations type are on the same type")
    @Constraint(need={JAnnotation.RepeatedAnnotationOnType.class})
    @Use(value={ContainerAnnotationMarkerAdder.class})
    @Access(value=JSession.class)
    @Filter(value={SourceTypeFilter.class})
    public static class TypeContainerAnnotationMarkerAdder
    extends ContainerAnnotationMarkerAdder
    implements RunnableSchedulable<JDefinedClassOrInterface> {
        @Override
        public void run(@Nonnull JDefinedClassOrInterface type) {
            this.addContainerAnnotationIfNeeded(type);
        }
    }
}

