/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.merger;

import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.io.EncodedValueCodec;
import com.android.jack.dx.io.EncodedValueReader;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstBoolean;
import com.android.jack.dx.rop.cst.CstByte;
import com.android.jack.dx.rop.cst.CstChar;
import com.android.jack.dx.rop.cst.CstDouble;
import com.android.jack.dx.rop.cst.CstFloat;
import com.android.jack.dx.rop.cst.CstInteger;
import com.android.jack.dx.rop.cst.CstKnownNull;
import com.android.jack.dx.rop.cst.CstLiteralBits;
import com.android.jack.dx.rop.cst.CstLong;
import com.android.jack.dx.rop.cst.CstShort;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.util.ByteInput;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class MergerTools {

    protected static final class ConstantValueArrayBuilder
    extends EncodedValueReader {
        @Nonnegative
        private int cstIndex = 0;
        @CheckForNull
        private Constant[] constantValues;
        @Nonnull
        private final DexBuffer dex;

        public ConstantValueArrayBuilder(@Nonnull DexBuffer dex, @Nonnull ByteInput in) {
            super(in);
            this.dex = dex;
        }

        @Nonnegative
        public int getCstSize() {
            assert (this.constantValues != null);
            return this.constantValues.length;
        }

        @Nonnull
        public Constant getCstValueAtIdx(@Nonnegative int idx) {
            assert (this.constantValues != null);
            assert (this.constantValues[idx] != null);
            return this.constantValues[idx];
        }

        @Override
        protected void visitArray(int size) {
            this.constantValues = new Constant[size];
        }

        @Override
        protected void visitEncodedBoolean(int argAndType) {
            int arg = (argAndType & 0xE0) >> 5;
            this.addConstant(CstBoolean.make(arg));
        }

        @Override
        protected void visitString(int type, int index) {
            this.addConstant(new CstString(this.dex.strings().get(index)));
        }

        @Override
        protected void visitEncodedNull(int argAndType) {
            this.addConstant(CstKnownNull.THE_ONE);
        }

        @Override
        protected void visitAnnotation(int typeIndex, int size) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitAnnotationName(int nameIndex) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitAnnotationValue(int argAndType) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitArrayValue(int argAndType) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitField(int type, int index) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitMethod(int type, int index) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitType(int type, int index) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitPrimitive(int argAndType, int type, int arg, int size) {
            CstLiteralBits cst;
            switch (type) {
                case 0: {
                    cst = CstByte.make((byte)EncodedValueCodec.readSignedInt(this.in, arg));
                    break;
                }
                case 3: {
                    cst = CstChar.make((char)EncodedValueCodec.readUnsignedInt(this.in, arg, false));
                    break;
                }
                case 2: {
                    cst = CstShort.make((short)EncodedValueCodec.readSignedInt(this.in, arg));
                    break;
                }
                case 4: {
                    cst = CstInteger.make(EncodedValueCodec.readSignedInt(this.in, arg));
                    break;
                }
                case 6: {
                    cst = CstLong.make(EncodedValueCodec.readSignedLong(this.in, arg));
                    break;
                }
                case 16: {
                    cst = CstFloat.make(EncodedValueCodec.readUnsignedInt(this.in, arg, true));
                    break;
                }
                case 17: {
                    cst = CstDouble.make(EncodedValueCodec.readUnsignedLong(this.in, arg, true));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.addConstant(cst);
        }

        private void addConstant(@Nonnull Constant cst) {
            assert (this.constantValues != null);
            this.constantValues[this.cstIndex++] = cst;
        }
    }
}

