/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.spec;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.shrob.proguard.GrammarActions;
import com.android.jack.shrob.spec.AnnotationSpecification;
import com.android.jack.shrob.spec.NameSpecification;
import com.android.jack.shrob.spec.Specification;
import com.android.sched.util.log.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class InheritanceSpecification
implements Specification<JDefinedClassOrInterface> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @CheckForNull
    private final AnnotationSpecification annotationType;
    @Nonnull
    private final NameSpecification className;

    public InheritanceSpecification(@Nonnull NameSpecification className, @CheckForNull AnnotationSpecification annotationType) {
        this.className = className;
        this.annotationType = annotationType;
    }

    private boolean checkNameAndAnnotations(@Nonnull JDefinedClassOrInterface type) {
        if (this.annotationType != null && !this.annotationType.matches(type.getAnnotations())) {
            return false;
        }
        return this.className.matches(GrammarActions.getSourceFormatter().getName(type));
    }

    @Override
    public boolean matches(@Nonnull JDefinedClassOrInterface type) {
        for (JInterface implement : type.getImplements()) {
            if (!(implement instanceof JDefinedClassOrInterface)) {
                logger.log(Level.WARNING, "Super interface {0} of {1} is missing from classpath.", new Object[]{Jack.getUserFriendlyFormatter().getName(implement), Jack.getUserFriendlyFormatter().getName(type)});
                continue;
            }
            JDefinedClassOrInterface classOrInterface = (JDefinedClassOrInterface)((Object)implement);
            if (!this.checkNameAndAnnotations(classOrInterface) && !this.matches(classOrInterface)) continue;
            return true;
        }
        JClass superclass = type.getSuperClass();
        if (superclass != null) {
            if (!(superclass instanceof JDefinedClassOrInterface)) {
                logger.log(Level.WARNING, "Super class {0} of {1} is missing from classpath.", new Object[]{Jack.getUserFriendlyFormatter().getName(superclass), Jack.getUserFriendlyFormatter().getName(type)});
            } else {
                JDefinedClassOrInterface definedSuper = (JDefinedClassOrInterface)((Object)superclass);
                return this.checkNameAndAnnotations(definedSuper) || this.matches(definedSuper);
            }
        }
        return false;
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder("extends ");
        if (this.annotationType != null) {
            sb.append(this.annotationType);
            sb.append(' ');
        }
        sb.append(this.className);
        return sb.toString();
    }
}

