/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.spec;

import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JType;
import com.android.jack.shrob.spec.SpecificationWithNegator;
import javax.annotation.Nonnull;

public class ClassTypeSpecification
extends SpecificationWithNegator<JType> {
    @Nonnull
    private final TypeEnum type;

    public ClassTypeSpecification(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public ClassTypeSpecification(@Nonnull TypeEnum type, boolean negator) {
        this.type = type;
        this.setNegator(negator);
    }

    @Override
    protected boolean matchesWithoutNegator(@Nonnull JType t) {
        switch (this.type) {
            case INTERFACE: {
                return t instanceof JDefinedInterface;
            }
            case CLASS: {
                return t instanceof JDefinedClass || t instanceof JDefinedInterface;
            }
            case ENUM: {
                return t instanceof JDefinedEnum;
            }
        }
        return true;
    }

    @Override
    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        switch (this.type) {
            case CLASS: {
                sb.append("class");
                break;
            }
            case ENUM: {
                sb.append("enum");
                break;
            }
            case INTERFACE: {
                sb.append("interface");
            }
        }
        return sb.toString();
    }

    public static enum TypeEnum {
        INTERFACE,
        CLASS,
        ENUM;

    }
}

