/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.shrink;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JSession;
import com.android.jack.shrob.shrink.KeepMarker;
import com.android.jack.shrob.shrink.ShrinkStatistic;
import com.android.jack.transformations.TypeRemover;
import com.android.sched.item.Description;
import com.android.sched.item.Synchronized;
import com.android.sched.marker.LocalMarkerManager;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import javax.annotation.Nonnull;

@Description(value="Removes all types not marked with the KeepMarker")
@Synchronized
@Constraint(need={KeepMarker.class})
@ExclusiveAccess(value=JSession.class)
public class TypeShrinker
extends TypeRemover {
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Override
    protected boolean mustBeRemoved(@Nonnull JDefinedClassOrInterface type) {
        return !this.isTypeFromClasspath(type) && !((LocalMarkerManager)type).containsMarker(KeepMarker.class);
    }

    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        super.run(type);
        this.tracer.getStatistic(ShrinkStatistic.TYPES_REMOVED).add(this.mustBeRemoved(type));
    }

    @Override
    protected boolean isPlannedForRemoval(@Nonnull JMethod method) {
        return method.getEnclosingType().isToEmit() && !((LocalMarkerManager)method).containsMarker(KeepMarker.class);
    }
}

