/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.shrink;

import com.android.jack.ir.ast.JNode;
import com.android.jack.shrob.spec.Specification;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class NodeFinder<T extends JNode> {
    @Nonnull
    private final List<T> toSearch;
    private boolean allMatched = true;

    public NodeFinder(@Nonnull List<T> toSearch) {
        this.toSearch = toSearch;
    }

    @Nonnull
    public List<T> find(@Nonnull List<? extends Specification<T>> specs) {
        ArrayList<JNode> found = new ArrayList<JNode>();
        for (Specification<JNode> specification : specs) {
            boolean matches = false;
            for (JNode t : this.toSearch) {
                if (!specification.matches(t)) continue;
                matches = true;
                if (found.contains(t)) continue;
                found.add(t);
            }
            if (matches) continue;
            this.allMatched = false;
        }
        return found;
    }

    public boolean allSpecificationsMatched() {
        return this.allMatched;
    }
}

