/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.shrink;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.shrob.shrink.KeepMarker;
import com.android.jack.shrob.shrink.PartialTypeHierarchy;
import com.android.jack.shrob.shrink.ShrinkStatistic;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Description;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

@Description(value="Removes all methods not marked with the KeepMarker")
@Synchronized
@Constraint(need={KeepMarker.class, PartialTypeHierarchy.class})
@ExclusiveAccess(value=JDefinedClassOrInterface.class)
public class MethodShrinker
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Override
    public synchronized void run(@Nonnull JMethod method) {
        boolean toRemove;
        boolean bl = toRemove = !method.containsMarker(KeepMarker.class);
        if (toRemove) {
            assert (method.getEnclosingType().getMarker(PartialTypeHierarchy.class) == null);
            TransformationRequest request = new TransformationRequest(method);
            request.append(new Remove(method));
            request.commit();
            logger.log(Level.INFO, "Removed method {0} from {1}", new Object[]{Jack.getUserFriendlyFormatter().getName(method), Jack.getUserFriendlyFormatter().getName(method.getEnclosingType())});
        }
        this.tracer.getStatistic(ShrinkStatistic.METHODS_REMOVED).add(toRemove);
    }
}

