/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation.resource;

import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.Options;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.Resource;
import com.android.jack.ir.naming.TypeName;
import com.android.jack.lookup.JLookup;
import com.android.jack.lookup.JLookupException;
import com.android.jack.reporting.ReportableIOException;
import com.android.jack.reporting.Reporter;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.shrob.obfuscation.resource.RefinedVFile;
import com.android.jack.shrob.spec.FilterSpecification;
import com.android.jack.shrob.spec.Flags;
import com.android.jack.util.NamingTools;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.HasLocation;
import com.android.sched.vfs.GenericInputVFile;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.VPath;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Refines string corresponding to type names in resources")
@Constraint(need={OriginalNames.class})
public class ResourceContentRefiner
implements RunnableSchedulable<JSession> {
    @Nonnull
    private final JLookup lookup = Jack.getSession().getLookup();
    @Nonnull
    private final List<FilterSpecification> adaptResourceFileContents = ThreadConfig.get(Options.FLAGS).getAdaptResourceFileContents();

    @Override
    public void run(@Nonnull JSession session) {
        List<Resource> resources = session.getResources();
        for (Resource res : resources) {
            VPath resName = res.getPath();
            if (!Flags.matches(this.adaptResourceFileContents, resName.getPathAsString('/'))) continue;
            InputVFile originalVFile = res.getVFile();
            RefinedVFile refinedVFile = new RefinedVFile(originalVFile.getVFile());
            int position = 0;
            try {
                try {
                    InputStreamReader reader = new InputStreamReader(originalVFile.getInputStream());
                    Throwable throwable = null;
                    try {
                        try {
                            int c = reader.read();
                            while (c != -1) {
                                if (Character.isJavaIdentifierStart(c)) {
                                    StringBuilder sb = new StringBuilder();
                                    sb.append((char)c);
                                    int startPosition = position++;
                                    c = reader.read();
                                    while (Character.isJavaIdentifierPart(c) || c == 46 || c == 45) {
                                        sb.append((char)c);
                                        c = reader.read();
                                        ++position;
                                    }
                                    String signatureName = NamingTools.getTypeSignatureName(sb.toString());
                                    if (NamingTools.isClassDescriptor(signatureName)) {
                                        try {
                                            JType type = this.lookup.getType(signatureName);
                                            refinedVFile.addRefinedEntry(startPosition, position - 1, new TypeName(TypeName.Kind.SRC_QN, type));
                                        }
                                        catch (JLookupException jLookupException) {
                                            // empty catch block
                                        }
                                    }
                                }
                                c = reader.read();
                                ++position;
                            }
                            res.setVFile(new GenericInputVFile(refinedVFile));
                        }
                        catch (IOException e) {
                            throw new CannotReadException(originalVFile, (Throwable)e);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new CannotCloseException((HasLocation)originalVFile, (Exception)e);
                }
            }
            catch (CannotCloseException | CannotReadException | WrongPermissionException e) {
                ReportableIOException reportable = new ReportableIOException("Resource content obfuscation", e);
                Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
                throw new JackAbortException(reportable);
            }
        }
    }
}

