/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation.annotation;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.shrob.obfuscation.annotation.AnnotationRemover;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

@Description(value="RunnableSchedulable that removes annotations from types.")
@Constraint(need={JAnnotation.class})
@Transform(modify={JAnnotation.class})
public class TypeAnnotationRemover
extends AnnotationRemover
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();

    public TypeAnnotationRemover() {
        super(ThreadConfig.get(EMIT_SOURCE_RETENTION_ANNOTATION), ThreadConfig.get(EMIT_CLASS_RETENTION_ANNOTATION), ThreadConfig.get(EMIT_RUNTIME_RETENTION_ANNOTATION), true);
    }

    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        TransformationRequest request = new TransformationRequest(type);
        for (JAnnotation annotation : type.getAnnotations()) {
            if (this.mustBeKept(annotation)) continue;
            request.append(new Remove(annotation));
            logger.log(Level.INFO, "Removed annotation {0} from type {1}", new Object[]{Jack.getUserFriendlyFormatter().getName(annotation.getType()), Jack.getUserFriendlyFormatter().getName(type)});
        }
        request.commit();
    }
}

