/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation.annotation;

import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.library.DumpInLibrary;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.id.BooleanPropertyId;
import javax.annotation.Nonnull;

@HasKeyId
public abstract class AnnotationRemover {
    @Nonnull
    public static final BooleanPropertyId EMIT_SOURCE_RETENTION_ANNOTATION = BooleanPropertyId.create("jack.annotation.source-retention", "Emit annotations that have a source retention").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId EMIT_CLASS_RETENTION_ANNOTATION = BooleanPropertyId.create("jack.annotation.class-retention", "Emit annotations that have a class retention").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId EMIT_RUNTIME_RETENTION_ANNOTATION = BooleanPropertyId.create("jack.annotation.runtime-retention", "Emit annotations that have a runtime retention").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class);
    private final boolean keepSourceAnnotations;
    private final boolean keepClassAnnotations;
    private final boolean keepRuntimeAnnotations;
    private final boolean keepSystemAnnotations;

    protected AnnotationRemover(boolean keepSourceAnnotations, boolean keepClassAnntations, boolean keepRuntimeAnnotations, boolean keepSystemAnnotations) {
        this.keepSourceAnnotations = keepSourceAnnotations;
        this.keepClassAnnotations = keepClassAnntations;
        this.keepRuntimeAnnotations = keepRuntimeAnnotations;
        this.keepSystemAnnotations = keepSystemAnnotations;
    }

    boolean mustBeKept(@Nonnull JAnnotation annotation) {
        switch (annotation.getRetentionPolicy()) {
            case SOURCE: {
                return this.keepSourceAnnotations;
            }
            case CLASS: {
                return this.keepClassAnnotations;
            }
            case RUNTIME: {
                return this.keepRuntimeAnnotations;
            }
            case SYSTEM: {
                return this.keepSystemAnnotations;
            }
        }
        throw new AssertionError();
    }
}

