/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.google.common.base.Function;
import com.android.jack.google.common.base.Joiner;
import com.android.jack.google.common.collect.Iterables;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JPhantomClassOrInterface;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.Reporter;
import com.android.jack.shrob.obfuscation.KeepNameMarker;
import com.android.jack.shrob.proguard.GrammarActions;
import com.android.jack.shrob.seed.SeedMarker;
import com.android.jack.shrob.spec.Flags;
import com.android.sched.item.Description;
import com.android.sched.marker.MarkerManager;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import javax.annotation.Nonnull;

@Description(value="Marks all classes and members that will not be renamed when obfuscating.")
@Transform(add={KeepNameMarker.class})
public class NameKeeper
implements RunnableSchedulable<JPackage> {
    @Nonnull
    private static final Joiner typeNameJoiner = Joiner.on(", ");
    @Nonnull
    protected final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final Flags flags = ThreadConfig.get(Options.FLAGS);

    private boolean markIfNecessary(@Nonnull MarkerManager node) {
        if (!node.containsMarker(KeepNameMarker.class)) {
            return node.addMarkerIfAbsent(KeepNameMarker.INSTANCE) == null;
        }
        return false;
    }

    private boolean isMarked(@Nonnull MarkerManager node) {
        return node.containsMarker(KeepNameMarker.class);
    }

    private void keepName(@Nonnull JPackage pack) {
        JPackage enclosingPackage;
        if (this.markIfNecessary(pack) && (enclosingPackage = pack.getEnclosingPackage()) != null) {
            this.keepName(enclosingPackage);
        }
    }

    private void keepName(@Nonnull JDefinedClassOrInterface type) {
        if (this.markIfNecessary(type)) {
            SeedMarker marker;
            this.keepName(type.getEnclosingPackage());
            for (JField field : type.getFields()) {
                marker = field.getMarker(SeedMarker.class);
                if (marker == null || marker.getModifier().allowObfuscation()) continue;
                this.keepName(field);
            }
            for (JMethod method : type.getMethods()) {
                marker = method.getMarker(SeedMarker.class);
                if (marker == null || marker.getModifier().allowObfuscation()) continue;
                this.keepName(method);
            }
        }
    }

    private void keepName(JMethod method) {
        JMethodIdWide methodId = method.getMethodIdWide();
        this.markIfNecessary(methodId);
    }

    private void keepName(JField field) {
        JFieldId fieldId = field.getId();
        this.markIfNecessary(fieldId);
    }

    @Override
    public void run(@Nonnull JPackage pack) {
        new Visitor().accept(pack);
    }

    private class Visitor
    extends JVisitor {
        private Visitor() {
        }

        @Override
        public boolean visit(@Nonnull JPackage pack) {
            if (!pack.getPhantoms().isEmpty()) {
                Jack.getSession().getReporter().report(Reporter.Severity.NON_FATAL, new KeepedPackageBecauseOfPhantom(pack));
                NameKeeper.this.keepName(pack);
            } else if (!NameKeeper.this.flags.getKeepPackageNames().isEmpty() && !NameKeeper.this.isMarked(pack) && Flags.matches(NameKeeper.this.flags.getKeepPackageNames(), GrammarActions.getSourceFormatter().getName(pack))) {
                NameKeeper.this.keepName(pack);
            }
            for (JDefinedClassOrInterface subType : pack.getTypes()) {
                subType.traverse(this);
            }
            return false;
        }

        @Override
        public boolean visit(@Nonnull JDefinedClassOrInterface clOrI) {
            if (!clOrI.isToEmit()) {
                NameKeeper.this.keepName(clOrI);
                for (JMethod m : clOrI.getMethods()) {
                    NameKeeper.this.keepName(m);
                }
                return false;
            }
            SeedMarker marker = clOrI.getMarker(SeedMarker.class);
            if (marker != null && !marker.getModifier().allowObfuscation()) {
                NameKeeper.this.keepName(clOrI);
            }
            for (JField field : clOrI.getFields()) {
                marker = field.getMarker(SeedMarker.class);
                if (marker == null || marker.getModifier().allowObfuscation()) continue;
                NameKeeper.this.keepName(field);
            }
            for (JMethod method : clOrI.getMethods()) {
                marker = method.getMarker(SeedMarker.class);
                if (marker == null || marker.getModifier().allowObfuscation()) continue;
                NameKeeper.this.keepName(method);
            }
            return super.visit(clOrI);
        }

        @Override
        public boolean visit(@Nonnull JMethod m) {
            if (JMethod.isClinit(m) || m instanceof JConstructor) {
                NameKeeper.this.keepName(m);
            }
            return false;
        }
    }

    private static class KeepedPackageBecauseOfPhantom
    implements Reportable {
        @Nonnull
        private final JPackage pack;

        public KeepedPackageBecauseOfPhantom(@Nonnull JPackage pack) {
            this.pack = pack;
        }

        @Override
        @Nonnull
        public String getMessage() {
            return "Obfuscation: force to keep package name '" + Jack.getUserFriendlyFormatter().getName(this.pack) + "' due to unknown referenced types " + typeNameJoiner.join(Iterables.transform(this.pack.getPhantoms(), new Function<JPhantomClassOrInterface, String>(){

                @Override
                public String apply(JPhantomClassOrInterface arg0) {
                    return Jack.getUserFriendlyFormatter().getName(arg0);
                }
            }));
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.WARNING;
        }
    }
}

