/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.scheduling.marker;

import com.android.jack.dx.dex.file.ClassDefItem;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.sched.item.ComposedOf;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Tag;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import javax.annotation.Nonnull;

@Description(value="A marker which contains a ClassDefItem instance.")
@ValidOn(value={JDefinedClassOrInterface.class})
public final class ClassDefItemMarker
implements Marker {
    @Nonnull
    private final ClassDefItem classDefItem;

    public ClassDefItemMarker(@Nonnull ClassDefItem classDefItem) {
        this.classDefItem = classDefItem;
    }

    @Nonnull
    public ClassDefItem getClassDefItem() {
        return this.classDefItem;
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        return this;
    }

    @Description(value="The ClassDefItem contained in the ClassDefItemMarker has annotations on class.")
    @Name(value="ClassDefItemMarker.ClassAnnotation")
    public static final class ClassAnnotation
    implements Tag {
    }

    @Description(value="The ClassDefItem contained in the ClassDefItemMarker has annotations on fields.")
    @Name(value="ClassDefItemMarker.FieldAnnotation")
    public static final class FieldAnnotation
    implements Tag {
    }

    @Description(value="The ClassDefItem contained in the ClassDefItemMarker has annotations on methods.")
    @Name(value="ClassDefItemMarker.MethodAnnotation")
    public static final class MethodAnnotation
    implements Tag {
    }

    @Description(value="The ClassDefItem contained in the ClassDefItemMarker has methods.")
    @Name(value="ClassDefItemMarker.Method")
    public static final class Method
    implements Tag {
    }

    @Description(value="The ClassDefItem contained in the ClassDefItemMarker has fields.")
    @Name(value="ClassDefItemMarker.Field")
    public static final class Field
    implements Tag {
    }

    @Description(value="The ClassDefItem contained in the ClassDefItemMarker is complete.")
    @ComposedOf(value={ClassDefItemMarker.class, Field.class, Method.class, ClassAnnotation.class, FieldAnnotation.class, MethodAnnotation.class})
    @Name(value="ClassDefItemMarker.Complete")
    public static final class Complete
    implements Tag {
    }
}

