/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.resource;

import com.android.jack.Jack;
import com.android.jack.backend.jayce.JayceFileImporter;
import com.android.jack.config.id.Arzon;
import com.android.jack.ir.ast.Resource;
import com.android.jack.resource.ResourceImportConflictException;
import com.android.jack.resource.ResourceOrMeta;
import com.android.jack.resource.ResourceOrMetaImporter;
import com.android.jack.resource.ResourceReadingException;
import com.android.jack.resource.StandaloneResOrMetaLocation;
import com.android.sched.util.codec.DirectoryInputVFSCodec;
import com.android.sched.util.codec.EnumCodec;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.ListPropertyId;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.InputVFS;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.VPath;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;

@HasKeyId
public class ResourceImporter
extends ResourceOrMetaImporter {
    @Nonnull
    public static final PropertyId<JayceFileImporter.CollisionPolicy> RESOURCE_COLLISION_POLICY = PropertyId.create("jack.import.resource.policy", "Defines the policy to follow concerning resource collision", new EnumCodec(JayceFileImporter.CollisionPolicy.class, (Enum[])JayceFileImporter.CollisionPolicy.values()).ignoreCase()).addDefaultValue(JayceFileImporter.CollisionPolicy.FAIL).addCategory(Arzon.class);
    @Nonnull
    public static final ListPropertyId<InputVFS> IMPORTED_RESOURCES = new ListPropertyId<InputVFS>("jack.import.resource", "Resources to import", new DirectoryInputVFSCodec().setInfoString("imported-rsc")).on(File.pathSeparator).minElements(0).addDefaultValue(Collections.emptyList());
    @Nonnull
    private final JayceFileImporter.CollisionPolicy resourceCollisionPolicy = ThreadConfig.get(RESOURCE_COLLISION_POLICY);

    public ResourceImporter(@Nonnull List<InputVFS> resourceDirs) {
        super(resourceDirs);
    }

    @Nonnull
    public List<Resource> getImports() throws ResourceReadingException {
        return super.getImports();
    }

    @Override
    protected void addImportedResource(@Nonnull InputVFile file, @Nonnull String currentPath, @Nonnull Location resourceDirLocation, @Nonnull List<ResourceOrMeta> resultList) throws ResourceImportConflictException {
        VPath path = new VPath(currentPath, '/');
        Resource newResource = new Resource(path, file, new StandaloneResourceLocation(resourceDirLocation, path));
        for (ResourceOrMeta existingResource : resultList) {
            if (!existingResource.getPath().equals(path)) continue;
            if (this.resourceCollisionPolicy == JayceFileImporter.CollisionPolicy.FAIL) {
                throw new ResourceImportConflictException((Resource)existingResource, newResource.getLocation());
            }
            Jack.getSession().getUserLogger().log(Level.INFO, "Resource in {0} has already been imported from {1}: ignoring import", new Object[]{newResource.getLocation().getDescription(), existingResource.getLocation().getDescription()});
            return;
        }
        resultList.add(newResource);
    }

    private static class StandaloneResourceLocation
    extends StandaloneResOrMetaLocation {
        public StandaloneResourceLocation(@Nonnull Location baseLocation, @Nonnull VPath path) {
            super(baseLocation, path);
        }

        @Override
        @Nonnull
        public String getDescription() {
            return this.baseLocation.getDescription() + ", resource '" + this.path.getPathAsString('/') + '\'';
        }
    }
}

