/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.reporting;

import com.android.jack.config.id.Arzon;
import com.android.jack.config.id.Brest;
import com.android.jack.config.id.Carnac;
import com.android.jack.reporting.DefaultReporter;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.SdkReporter;
import com.android.sched.util.codec.EnumCodec;
import com.android.sched.util.codec.ListCodec;
import com.android.sched.util.codec.PairCodec;
import com.android.sched.util.codec.PairListToMapCodecConverter;
import com.android.sched.util.codec.VariableName;
import com.android.sched.util.codec.WriterFileCodec;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.id.ImplementationPropertyId;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.config.id.WriterFilePropertyId;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.WriterFile;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.stream.CustomPrintWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

@HasKeyId
@VariableName(value="reporter")
public interface Reporter {
    @Nonnull
    public static final ImplementationPropertyId<Reporter> REPORTER = ((ImplementationPropertyId)ImplementationPropertyId.create("jack.reporter", "Define which reporter will be used", Reporter.class).addDefaultValue("default")).addCategory(Arzon.class);
    @Nonnull
    public static final WriterFilePropertyId REPORTER_WRITER = WriterFilePropertyId.create("jack.reporter.file", "File where the reporter will write", new WriterFileCodec(FileOrDirectory.Existence.MAY_EXIST).allowStandardOutputOrError().allowCharset()).addDefaultValue("--").requiredIf(REPORTER.getClazz().isImplementedBy(DefaultReporter.class).or(REPORTER.getClazz().isImplementedBy(SdkReporter.class))).addCategory(Brest.class);
    @Nonnull
    public static final PropertyId<Map<Reportable.ProblemLevel, WriterFile>> REPORTER_WRITER_BY_LEVEL = ((PropertyId)PropertyId.create("jack.reporter.level.file", "File where the reporter will write by level", new PairListToMapCodecConverter(new ListCodec(new PairCodec(new EnumCodec(Reportable.ProblemLevel.class, (Enum[])Reportable.ProblemLevel.values()).ignoreCase(), new WriterFileCodec(FileOrDirectory.Existence.MAY_EXIST).allowStandardOutputOrError().allowCharset()).on("=")).setMin(0))).addDefaultValue(Collections.emptyMap()).addCategory(Carnac.class)).setShutdownHook(new PropertyId.ShutdownRunnable<Map<Reportable.ProblemLevel, WriterFile>>(){
        @Nonnull
        private final Logger logger = LoggerFactory.getLogger();

        @Override
        public void run(@Nonnull Map<Reportable.ProblemLevel, WriterFile> map) {
            for (WriterFile osf : map.values()) {
                CustomPrintWriter writer = osf.getPrintWriter();
                try {
                    writer.throwPendingException();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, "Pending exception writing '" + osf.getPath() + "' from property 'jack.reporter.level.file'", e);
                }
                try {
                    writer.close();
                    writer.throwPendingException();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, "Failed to close '" + osf.getPath() + "' from property 'jack.reporter.level.file'", e);
                }
            }
        }
    });

    public void report(@Nonnull Severity var1, @Nonnull Reportable var2);

    public static enum Severity {
        FATAL,
        NON_FATAL;

    }
}

