/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.preprocessor;

import com.android.jack.Jack;
import com.android.jack.antlr.runtime.ANTLRReaderStream;
import com.android.jack.antlr.runtime.CommonTokenStream;
import com.android.jack.antlr.runtime.RecognitionException;
import com.android.jack.ir.ast.Annotable;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JSession;
import com.android.jack.library.FileType;
import com.android.jack.library.InputLibrary;
import com.android.jack.preprocessor.AddAnnotationStep;
import com.android.jack.preprocessor.Context;
import com.android.jack.preprocessor.PreProcessor;
import com.android.jack.preprocessor.PreProcessorLexer;
import com.android.jack.preprocessor.PreProcessorParser;
import com.android.jack.preprocessor.Rule;
import com.android.jack.preprocessor.TypeToEmitScope;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.ReportableException;
import com.android.jack.reporting.Reporter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.ReaderFile;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.InputVFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.Nonnull;

@Description(value="Apply the rules defined in the PreProcessor file.")
@Support(value={PreProcessor.class})
public class PreProcessorApplier
implements RunnableSchedulable<JSession> {
    @Override
    public void run(@Nonnull JSession session) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (ThreadConfig.get(PreProcessor.ENABLE).booleanValue()) {
            ReaderFile inputFile = ThreadConfig.get(PreProcessor.FILE);
            try {
                try (BufferedReader inputStream = inputFile.getBufferedReader();){
                    rules.addAll(this.parseRules(session, inputStream, inputFile.getLocation()));
                }
                catch (IOException e) {
                    throw new CannotCloseException((HasLocation)inputFile, (Exception)e);
                }
            }
            catch (RecognitionException | CannotCloseException | CannotReadException e) {
                JppParsingException reportable = new JppParsingException(inputFile, (Throwable)e);
                Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
                Jack.getSession().abortEventually();
            }
        }
        Iterator<InputLibrary> iter = session.getPathSources();
        while (iter.hasNext()) {
            InputLibrary inputLibrary = iter.next();
            Iterator<InputVFile> metaFileIt = inputLibrary.iterator(FileType.META);
            while (metaFileIt.hasNext()) {
                InputVFile inputFile = metaFileIt.next();
                if (!inputFile.getName().endsWith(".jpp")) continue;
                try {
                    try {
                        InputStream inputStream = inputFile.getInputStream();
                        Throwable throwable = null;
                        try {
                            rules.addAll(this.parseRules(session, new InputStreamReader(inputStream), inputFile.getLocation()));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        throw new CannotCloseException((HasLocation)inputFile, (Exception)e);
                    }
                }
                catch (RecognitionException | CannotCloseException | CannotReadException | WrongPermissionException e) {
                    JppParsingException reportable = new JppParsingException(inputFile, (Throwable)e);
                    Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
                    Jack.getSession().abortEventually();
                }
            }
        }
        this.applyRules(rules, session);
    }

    @Nonnull
    private Collection<Rule> parseRules(@Nonnull JSession session, @Nonnull Reader reader, @Nonnull Location location) throws RecognitionException, CannotReadException {
        ANTLRReaderStream in;
        try {
            in = new ANTLRReaderStream(reader);
        }
        catch (IOException e) {
            throw new CannotReadException(location, (Throwable)e);
        }
        PreProcessorLexer lexer = new PreProcessorLexer(in);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        PreProcessorParser parser = new PreProcessorParser(tokens);
        return parser.rules(session, location);
    }

    private void applyRules(@Nonnull Collection<Rule> rules, @Nonnull JSession session) {
        TypeToEmitScope scope = new TypeToEmitScope(session);
        ArrayList<AddAnnotationStep> requests = new ArrayList<AddAnnotationStep>();
        for (Rule rule : rules) {
            Context context = new Context(rule);
            if (rule.getSet().eval(scope, context).isEmpty()) continue;
            requests.addAll(context.getSteps());
        }
        HashMap<Entry, Rule> map = new HashMap<Entry, Rule>();
        for (AddAnnotationStep request : requests) {
            request.apply(map);
        }
    }

    private static class JppParsingException
    extends ReportableException
    implements HasLocation {
        private static final long serialVersionUID = 1L;
        @Nonnull
        private final HasLocation locationProvider;

        public JppParsingException(@Nonnull HasLocation locationProvider, @Nonnull Throwable cause) {
            super(cause);
            this.locationProvider = locationProvider;
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.ERROR;
        }

        @Override
        @Nonnull
        public Location getLocation() {
            return this.locationProvider.getLocation();
        }
    }

    static class Entry {
        @Nonnull
        public final Annotable annotated;
        @Nonnull
        public final JAnnotationType annotationType;

        public Entry(@Nonnull Annotable annotated, @Nonnull JAnnotationType annotationType) {
            this.annotated = annotated;
            this.annotationType = annotationType;
        }

        public final boolean equals(Object obj) {
            if (obj instanceof Entry) {
                Entry entry = (Entry)obj;
                return entry.annotated == this.annotated && entry.annotationType.equals(this.annotationType);
            }
            return false;
        }

        public int hashCode() {
            return this.annotated.hashCode() ^ this.annotationType.hashCode();
        }
    }
}

