/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.preprocessor;

import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JType;
import com.android.jack.preprocessor.Context;
import com.android.jack.preprocessor.Expression;
import com.android.jack.preprocessor.Scope;
import com.android.jack.preprocessor.SingleTypeScope;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ArrayFilter
implements Expression<Collection<JArrayType>, Scope> {
    @Nonnull
    private final Expression<Collection<? extends JType>, Scope> leafType;
    @Nonnegative
    private final int dim;

    public ArrayFilter(@Nonnull Expression<Collection<? extends JType>, Scope> leafType, @Nonnegative int dim) {
        this.leafType = leafType;
        this.dim = dim;
    }

    @Override
    @Nonnull
    public Collection<JArrayType> eval(@Nonnull Scope scope, @Nonnull Context context) {
        JArrayType arrayToMatch;
        JType toMatch;
        if (scope instanceof SingleTypeScope && (toMatch = ((SingleTypeScope)scope).getElement()) instanceof JArrayType && (arrayToMatch = (JArrayType)toMatch).getDims() == this.dim && !this.leafType.eval(new SingleTypeScope(arrayToMatch.getLeafType()), context).isEmpty()) {
            return Collections.singleton(arrayToMatch);
        }
        return Collections.emptySet();
    }
}

