/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.plugin;

import com.android.jack.google.common.base.Function;
import com.android.jack.google.common.base.Joiner;
import com.android.jack.google.common.base.Predicate;
import com.android.jack.google.common.collect.Iterators;
import com.android.jack.plugin.PluginSelector;
import com.android.jack.plugin.v01.Plugin;
import com.android.sched.util.UncomparableVersion;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.LoggerFactory;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

@ImplementationName(iface=PluginSelector.class, name="last")
public class Last
implements PluginSelector {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();

    @Override
    @Nonnull
    public Plugin select(@Nonnull List<Plugin> plugins) {
        Plugin selected = plugins.get(0);
        for (Plugin plugin : plugins) {
            try {
                if (!plugin.getVersion().isNewerThan(selected.getVersion())) continue;
                selected = plugin;
            }
            catch (UncomparableVersion uncomparableVersion) {}
        }
        if (logger.isLoggable(Level.INFO)) {
            if (plugins.size() > 1) {
                final Plugin one = selected;
                StringBuilder others = new StringBuilder();
                Joiner.on(", ").appendTo(others, Iterators.transform(Iterators.filter(plugins.iterator(), new Predicate<Plugin>(){

                    @Override
                    public boolean apply(Plugin plugin) {
                        return plugin != one;
                    }
                }), new Function<Plugin, String>(){

                    @Override
                    public String apply(Plugin plugin) {
                        return plugin.getVersion().getVersion();
                    }
                }));
                logger.log(Level.INFO, "For plugin ''{0}'', selected version {1} because newer than {2}", new Object[]{selected.getCanonicalName(), selected.getVersion().getVersion(), others});
            } else {
                logger.log(Level.INFO, "For plugin ''{0}'', selected version {1} because alone", new Object[]{selected.getCanonicalName(), selected.getVersion().getVersion()});
            }
        }
        return selected;
    }
}

