/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.wofr;

import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.optimizations.common.OptimizerUtils;
import com.android.jack.optimizations.wofr.FieldReadWriteCountsMarker;
import com.android.jack.optimizations.wofr.WofrSchedulable;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Write-only field removal, field usage collection")
@Constraint(need={JFieldRef.class}, no={JFieldInitializer.class})
@Transform(add={FieldReadWriteCountsMarker.class})
@Name(value="WriteOnlyFieldRemoval: CollectFieldAccesses")
public class WofrCollectFieldAccesses
extends WofrSchedulable
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private static final JVisitor ANALYZER = new JVisitor(){

        @Override
        public void endVisit(@Nonnull JFieldRef ref) {
            JField field = ref.getFieldId().getField();
            if (field != null && field.getEnclosingType().isToEmit()) {
                if (OptimizerUtils.isAssigned(ref)) {
                    boolean isNonLiteral = OptimizerUtils.asLiteralOrDefault(OptimizerUtils.getAssignedValue(ref), null) == null;
                    FieldReadWriteCountsMarker.markWrite(field, isNonLiteral);
                } else {
                    FieldReadWriteCountsMarker.markRead(field);
                }
            }
            super.endVisit(ref);
        }
    };

    @Override
    public void run(@Nonnull JMethod method) {
        if (!method.isAbstract() && !method.isNative()) {
            ANALYZER.accept(method);
        }
    }
}

