/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.valuepropagation.argument;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Represent tainted methods on a defined type")
@ValidOn(value={JDefinedClassOrInterface.class})
public class TaintedVirtualMethodsMarker
implements Marker {
    @Nonnull
    private static final TaintedVirtualMethodsMarker ALL_VIRTUAL_METHODS_TAINTED = new TaintedVirtualMethodsMarker(null);
    @CheckForNull
    private final Set<String> tainted;

    private TaintedVirtualMethodsMarker(@CheckForNull Set<String> tainted) {
        this.tainted = tainted;
    }

    public boolean isMethodTainted(@Nonnull String signature) {
        return this.tainted == null || this.tainted.contains(signature);
    }

    public boolean allMethodsAreTainted() {
        return this.tainted == null;
    }

    @CheckForNull
    public static TaintedVirtualMethodsMarker getMarker(@Nonnull JDefinedClassOrInterface type) {
        return type.getMarker(TaintedVirtualMethodsMarker.class);
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        throw new AssertionError();
    }

    public static class Builder {
        @Nonnull
        private final JDefinedClassOrInterface type;
        @Nonnull
        private final Set<String> tainted = new HashSet<String>();

        public Builder(@Nonnull JDefinedClassOrInterface type) {
            this.type = type;
        }

        @Nonnull
        public TaintedVirtualMethodsMarker createAndAddAsAllTainted() {
            TaintedVirtualMethodsMarker existing = this.type.addMarkerIfAbsent(ALL_VIRTUAL_METHODS_TAINTED);
            return existing != null ? existing : ALL_VIRTUAL_METHODS_TAINTED;
        }

        @Nonnull
        public TaintedVirtualMethodsMarker createAndAdd() {
            TaintedVirtualMethodsMarker marker = new TaintedVirtualMethodsMarker(this.tainted);
            TaintedVirtualMethodsMarker existing = this.type.addMarkerIfAbsent(marker);
            return existing != null ? existing : marker;
        }

        public void mergeWith(@Nonnull TaintedVirtualMethodsMarker other) {
            assert (other.tainted != null);
            this.tainted.addAll(other.tainted);
        }

        public void addTaintedMethod(@Nonnull String signature) {
            this.tainted.add(signature);
        }
    }
}

