/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.valuepropagation.argument;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import javax.annotation.Nonnull;

public class AvpSchedulable {
    @Nonnull
    public static final StatisticId<Counter> ARGUMENT_VALUES_PROPAGATED = new StatisticId<Counter>("jack.optimization.argument-value-propagation.propagated", "Argument values propagated", CounterImpl.class, Counter.class);
    @Nonnull
    public static final StatisticId<Counter> PARAMETER_IS_WRITTEN_TO = new StatisticId<Counter>("jack.optimization.argument-value-propagation.written-to", "Parameters with a value to propagate being written to", CounterImpl.class, Counter.class);
    @Nonnull
    private final TypePackageAndMethodFormatter formatter = Jack.getLookupFormatter();

    @Nonnull
    String getMethodSignature(@Nonnull JMethodIdWide method, @Nonnull JType returnType) {
        return this.formatter.getName(method.getName(), method.getParamTypes(), returnType);
    }

    @Nonnull
    String getMethodSignature(@Nonnull JMethod method) {
        return this.getMethodSignature(method.getMethodIdWide(), method.getType());
    }

    @Description(value="Marks tainted methods")
    @ValidOn(value={JMethod.class})
    static enum TaintedMethodMarker implements Marker
    {
        TAINTED;


        static void markAsTainted(@Nonnull JMethod method) {
            if (!method.containsMarker(TaintedMethodMarker.class)) {
                method.addMarker(TAINTED);
            }
        }

        static boolean checkIfTaintedAndRemoveMarker(@Nonnull JMethod method) {
            return method.removeMarker(TaintedMethodMarker.class) != null;
        }

        @Override
        @Nonnull
        public Marker cloneIfNeeded() {
            return this;
        }
    }
}

