/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.valuepropagation.argument;

import com.android.jack.Jack;
import com.android.jack.annotations.DisableArgumentValuePropagationOptimization;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.optimizations.common.ExpressionReplaceHelper;
import com.android.jack.optimizations.common.LiteralValueListTracker;
import com.android.jack.optimizations.common.OptimizerUtils;
import com.android.jack.optimizations.valuepropagation.argument.AvpSchedulable;
import com.android.jack.optimizations.valuepropagation.argument.MethodCallArgumentsMarker;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.NamingTools;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Argument value propagation, propagate argument value when possible")
@Constraint(need={MethodCallArgumentsMarker.class, AvpSchedulable.TaintedMethodMarker.class})
@Transform(remove={MethodCallArgumentsMarker.class, AvpSchedulable.TaintedMethodMarker.class})
@Use(value={ExpressionReplaceHelper.class})
@Name(value="ArgumentValuePropagation: PropagateArgumentValues")
public class AvpPropagateArgumentValues
extends AvpSchedulable
implements RunnableSchedulable<JMethod> {
    @Nonnull
    public final JAnnotationType disablingAnnotationType = Jack.getSession().getPhantomLookup().getAnnotationType(NamingTools.getTypeSignatureName(DisableArgumentValuePropagationOptimization.class.getName()));
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Override
    public void run(final @Nonnull JMethod method) {
        LiteralValueListTracker tracker = MethodCallArgumentsMarker.getTrackerAndRemoveMarker(method);
        boolean isTainted = AvpSchedulable.TaintedMethodMarker.checkIfTaintedAndRemoveMarker(method);
        if (isTainted || tracker == null || !tracker.hasAtLeastOneLiteral() || method.isAbstract() || method.isNative() || !method.getAnnotations(this.disablingAnnotationType).isEmpty() || !method.getEnclosingType().getAnnotations(this.disablingAnnotationType).isEmpty()) {
            return;
        }
        final HashMap<JParameter, JValueLiteral> paramValues = new HashMap<JParameter, JValueLiteral>();
        List<JParameter> params = method.getParams();
        for (int i = 0; i < params.size(); ++i) {
            JValueLiteral value;
            if (tracker.isMultipleOrNonLiteralValue(i) || (value = tracker.getConsolidatedValue(i)) == null) continue;
            paramValues.put(params.get(i), value);
        }
        JVisitor asgAnalyzer = new JVisitor(){

            @Override
            public void endVisit(@Nonnull JParameterRef x) {
                JNode parent = x.getParent();
                if (parent instanceof JAsgOperation && ((JAsgOperation)parent).getLhs() == x && paramValues.remove(x.getParameter()) != null) {
                    AvpPropagateArgumentValues.this.tracer.getStatistic(AvpSchedulable.PARAMETER_IS_WRITTEN_TO).incValue();
                }
            }
        };
        asgAnalyzer.accept(method);
        if (paramValues.size() == 0) {
            return;
        }
        class Processor
        extends JVisitor {
            @Nonnull
            private TransformationRequest request;
            @Nonnull
            private ExpressionReplaceHelper helper;

            Processor() {
                this.request = new TransformationRequest(method);
                this.helper = new ExpressionReplaceHelper(new LocalVarCreator(method, "avp"));
            }

            @Override
            public void endVisit(@Nonnull JParameterRef x) {
                JParameter parameter = x.getParameter();
                JValueLiteral literal = (JValueLiteral)paramValues.get(parameter);
                if (literal != null && parameter.getAnnotations(AvpPropagateArgumentValues.this.disablingAnnotationType).isEmpty()) {
                    literal = OptimizerUtils.cloneExpression(literal);
                    literal.setSourceInfo(x.getSourceInfo());
                    this.helper.replace(x, literal, this.request);
                    AvpPropagateArgumentValues.this.tracer.getStatistic(AvpSchedulable.ARGUMENT_VALUES_PROPAGATED).incValue();
                }
            }
        }
        Processor processor = new Processor();
        processor.accept(method);
        processor.request.commit();
    }
}

