/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.valuepropagation.argument;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JPhantomClassOrInterface;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.optimizations.valuepropagation.argument.AvpSchedulable;
import com.android.jack.optimizations.valuepropagation.argument.TaintedVirtualMethodsMarker;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Argument value propagation, calculate tainted methods on types to be emitted")
@Transform(add={TaintedVirtualMethodsMarker.class})
@Name(value="ArgumentValuePropagation: AvpCalculateTaintedMethods")
public class AvpCalculateTaintedMethods
extends AvpSchedulable
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Nonnull
    private TaintedVirtualMethodsMarker calculateTaintedVirtualMethods(@Nonnull JDefinedClassOrInterface type) {
        TaintedVirtualMethodsMarker marker = TaintedVirtualMethodsMarker.getMarker(type);
        if (marker != null) {
            return marker;
        }
        TaintedVirtualMethodsMarker.Builder builder = new TaintedVirtualMethodsMarker.Builder(type);
        for (JInterface impl : type.getImplements()) {
            marker = TaintedVirtualMethodsMarker.getMarker(type);
            if (marker != null) {
                return marker;
            }
            if (impl instanceof JPhantomClassOrInterface) {
                return builder.createAndAddAsAllTainted();
            }
            TaintedVirtualMethodsMarker other = this.getOrCreateMarker((JDefinedClassOrInterface)((Object)impl));
            if (other.allMethodsAreTainted()) {
                return builder.createAndAddAsAllTainted();
            }
            builder.mergeWith(other);
        }
        JClass superClass = type.getSuperClass();
        if (superClass != null) {
            marker = TaintedVirtualMethodsMarker.getMarker(type);
            if (marker != null) {
                return marker;
            }
            if (superClass instanceof JPhantomClassOrInterface) {
                return builder.createAndAddAsAllTainted();
            }
            TaintedVirtualMethodsMarker other = this.getOrCreateMarker((JDefinedClassOrInterface)((Object)superClass));
            if (other.allMethodsAreTainted()) {
                return builder.createAndAddAsAllTainted();
            }
            builder.mergeWith(other);
        }
        if ((marker = TaintedVirtualMethodsMarker.getMarker(type)) != null) {
            return marker;
        }
        if (!type.isToEmit()) {
            for (JMethod method : type.getMethods()) {
                JMethodIdWide idWide = method.getMethodIdWide();
                if (idWide.getKind() != MethodKind.INSTANCE_VIRTUAL || idWide.getParamTypes().size() <= 0) continue;
                builder.addTaintedMethod(this.getMethodSignature(method));
            }
        }
        return builder.createAndAdd();
    }

    @Nonnull
    private TaintedVirtualMethodsMarker getOrCreateMarker(@Nonnull JDefinedClassOrInterface type) {
        TaintedVirtualMethodsMarker marker = TaintedVirtualMethodsMarker.getMarker(type);
        if (marker != null) {
            return marker;
        }
        return this.calculateTaintedVirtualMethods(type);
    }

    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        this.getOrCreateMarker(type);
    }
}

