/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.modifiers;

import com.android.jack.Jack;
import com.android.jack.analysis.common.ReachabilityAnalyzer;
import com.android.jack.annotations.DisableFieldFinalizerOptimization;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.google.common.collect.Maps;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.optimizations.Optimizations;
import com.android.jack.optimizations.modifiers.EffectivelyFinalFieldMarker;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.NamingTools;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class FieldFinalizer {
    @Nonnull
    public static final StatisticId<Counter> FIELDS_FINALIZED = new StatisticId<Counter>("jack.optimization.fields-finalizer", "Fields made final", CounterImpl.class, Counter.class);

    private static boolean isConstructor(@Nonnull JMethod method) {
        return method instanceof JConstructor || JMethod.isClinit(method);
    }

    @Description(value="Field finalizer, finalizing phase")
    @Constraint(need={NotEffectivelyFinalField.class})
    @Transform(remove={NotEffectivelyFinalField.class}, add={EffectivelyFinalFieldMarker.class})
    public static class FinalizingPhase
    implements RunnableSchedulable<JField> {
        private final boolean addFinalModifier = ThreadConfig.get(Optimizations.FieldFinalizer.ADD_FINAL_MODIFIER);
        @Nonnull
        private final JAnnotationType disablingAnnotationType = Jack.getSession().getPhantomLookup().getAnnotationType(NamingTools.getTypeSignatureName(DisableFieldFinalizerOptimization.class.getName()));
        @Nonnull
        private final Tracer tracer = TracerFactory.getTracer();

        @Override
        public void run(@Nonnull JField field) {
            if (field.isFinal() || field.isVolatile() || !NotEffectivelyFinalField.checkIfCanBeFinalAndRemoveMarker(field) || !(field.getEnclosingType() instanceof JDefinedClass)) {
                return;
            }
            EffectivelyFinalFieldMarker.markAsEffectivelyFinal(field);
            if (this.addFinalModifier && field.getAnnotations(this.disablingAnnotationType).isEmpty() && field.getEnclosingType().getAnnotations(this.disablingAnnotationType).isEmpty()) {
                field.setFinal();
                this.tracer.getStatistic(FIELDS_FINALIZED).incValue();
            }
        }
    }

    @Description(value="Field finalizer, analyze constructors if needs to preserve JLS")
    @Constraint(need={ControlFlowGraph.class}, no={JFieldInitializer.class})
    @Access(value=JDefinedClassOrInterface.class)
    @Transform(add={NotEffectivelyFinalField.class})
    public static class ConstructorsAnalysisPhase
    implements RunnableSchedulable<JMethod> {
        private final boolean enforceInitSemantic = ThreadConfig.get(Optimizations.FieldFinalizer.ENFORCE_INIT_SEMANTIC);

        @Override
        public void run(@Nonnull JMethod method) {
            if (!this.enforceInitSemantic || !FieldFinalizer.isConstructor(method)) {
                return;
            }
            JDefinedClassOrInterface type = method.getEnclosingType();
            if (!(type instanceof JDefinedClass)) {
                return;
            }
            Analyzer analyzer = new Analyzer(type.getFields(), method);
            if (!analyzer.isEmpty()) {
                analyzer.analyze();
            }
        }

        private static class Analyzer
        extends ReachabilityAnalyzer<State> {
            @Nonnull
            private JMethod constructor;
            @Nonnull
            private final Map<JField, Integer> field2id;

            Analyzer(@Nonnull List<JField> fields, @Nonnull JMethod constructor) {
                this.constructor = constructor;
                this.field2id = Maps.newHashMap();
                for (JField field : fields) {
                    if (field.isFinal() || field.isVolatile() || !NotEffectivelyFinalField.checkIfCanBeFinal(field)) continue;
                    this.field2id.put(field, this.field2id.size());
                }
            }

            public boolean isEmpty() {
                return this.field2id.isEmpty();
            }

            @Override
            @Nonnull
            public ControlFlowGraph getCfg() {
                ControlFlowGraph cfg = this.constructor.getMarker(ControlFlowGraph.class);
                assert (cfg != null);
                return cfg;
            }

            @Override
            public void finalize(@Nonnull List<State> in, @Nonnull List<State> out, @Nonnull List<State> outException) {
                State exitBlockState = this.newState(false);
                this.recalculateInSet((BasicBlock)this.getCfg().getExitNode(), true, exitBlockState, out, outException);
                for (Map.Entry<JField, Integer> entry : this.field2id.entrySet()) {
                    JField field = entry.getKey();
                    if (field.isStatic() != this.constructor.isStatic() || exitBlockState.definitelyAssigned.get(entry.getValue())) continue;
                    NotEffectivelyFinalField.markAsNotFinal(field);
                }
            }

            @Override
            @Nonnull
            public State newState(boolean entry) {
                return new State(this.field2id.size());
            }

            @Override
            public void copyState(@Nonnull State src, @Nonnull State dest) {
                dest.maybeAssigned.clear();
                dest.maybeAssigned.or(src.maybeAssigned);
                dest.definitelyAssigned.clear();
                dest.definitelyAssigned.or(src.definitelyAssigned);
            }

            @Override
            public void mergeState(@Nonnull State state, @Nonnull State otherState) {
                state.maybeAssigned.or(otherState.maybeAssigned);
                state.definitelyAssigned.and(otherState.definitelyAssigned);
            }

            @Override
            public void processStatement(@Nonnull State outBs, @Nonnull JStatement stmt) {
                if (stmt instanceof JExpressionStatement) {
                    JExpression expr = ((JExpressionStatement)stmt).getExpr();
                    if (expr instanceof JAsgOperation) {
                        JExpression lhs = ((JAsgOperation)expr).getLhs();
                        if (lhs instanceof JFieldRef) {
                            JField field = ((JFieldRef)lhs).getFieldId().getField();
                            if (field == null) {
                                return;
                            }
                            Integer index = this.field2id.get(field);
                            if (index == null) {
                                return;
                            }
                            int idx = index;
                            if (outBs.maybeAssigned.get(idx)) {
                                NotEffectivelyFinalField.markAsNotFinal(field);
                            }
                            outBs.maybeAssigned.set(idx);
                            outBs.definitelyAssigned.set(idx);
                        }
                    } else if (expr instanceof JMethodCall) {
                        if (this.constructor.isStatic()) {
                            return;
                        }
                        JMethodCall call = (JMethodCall)expr;
                        if (!call.getMethodId().isInit() || !(call.getInstance() instanceof JThisRef)) {
                            return;
                        }
                        assert (call.getDispatchKind() == JMethodCall.DispatchKind.DIRECT);
                        assert (this.constructor.getMethodIdWide().getKind() == MethodKind.INSTANCE_NON_VIRTUAL);
                        if (call.getReceiverType() != this.constructor.getEnclosingType()) {
                            return;
                        }
                        for (Map.Entry<JField, Integer> e : this.field2id.entrySet()) {
                            JField field = e.getKey();
                            if (field.isStatic()) continue;
                            int index = e.getValue();
                            if (outBs.maybeAssigned.get(index)) {
                                NotEffectivelyFinalField.markAsNotFinal(field);
                            }
                            outBs.maybeAssigned.set(index);
                            outBs.definitelyAssigned.set(index);
                        }
                    }
                }
            }

            @Override
            @Nonnull
            public State cloneState(@Nonnull State state) {
                State clone = new State(this.field2id.size());
                clone.maybeAssigned.or(state.maybeAssigned);
                clone.definitelyAssigned.or(state.definitelyAssigned);
                return clone;
            }
        }

        private static class State {
            final BitSet maybeAssigned;
            final BitSet definitelyAssigned;

            private State(@Nonnegative int size) {
                this.maybeAssigned = new BitSet(size);
                this.definitelyAssigned = new BitSet(size);
            }

            public final int hashCode() {
                throw new AssertionError();
            }

            public final boolean equals(Object o) {
                return o instanceof State && ((State)o).maybeAssigned.equals(this.maybeAssigned) && ((State)o).definitelyAssigned.equals(this.definitelyAssigned);
            }
        }
    }

    @Description(value="Field finalizer, collecting assignment information phase")
    @Constraint(need={ThreeAddressCodeForm.class})
    @Transform(add={NotEffectivelyFinalField.class})
    public static class CollectionPhase
    implements RunnableSchedulable<JMethod> {
        @Override
        public void run(@Nonnull JMethod method) {
            if (!method.isNative() && !method.isAbstract()) {
                new Visitor(method).accept(method);
            }
        }

        private static class Visitor
        extends JVisitor {
            @CheckForNull
            final JMethod constructor;

            private Visitor(@Nonnull JMethod method) {
                this.constructor = FieldFinalizer.isConstructor(method) ? method : null;
            }

            private boolean isAssignment(@Nonnull JFieldRef fieldRef) {
                JNode parent = fieldRef.getParent();
                return parent instanceof JAsgOperation && ((JAsgOperation)parent).getLhs() == fieldRef;
            }

            @Override
            public void endVisit(@Nonnull JFieldRef fieldRef) {
                JField field = fieldRef.getFieldId().getField();
                if (field != null && this.isAssignment(fieldRef)) {
                    JDefinedClassOrInterface enclosingType = field.getEnclosingType();
                    if (!field.isVolatile() && !field.isFinal() && enclosingType.isToEmit()) {
                        boolean isAllowedReference;
                        boolean bl = isAllowedReference = this.constructor != null && this.constructor.getEnclosingType() == enclosingType && this.constructor.isStatic() == field.isStatic();
                        if (!isAllowedReference) {
                            NotEffectivelyFinalField.markAsNotFinal(field);
                        }
                    }
                }
                super.endVisit(fieldRef);
            }
        }
    }

    @Description(value="Marker is used to mark fields which are NOT effectively final.")
    @ValidOn(value={JField.class})
    public static final class NotEffectivelyFinalField
    extends Enum<NotEffectivelyFinalField>
    implements Marker {
        public static final /* enum */ NotEffectivelyFinalField NOT_EFFECTIVELY_FINAL = new NotEffectivelyFinalField();
        private static final /* synthetic */ NotEffectivelyFinalField[] $VALUES;

        public static NotEffectivelyFinalField[] values() {
            return (NotEffectivelyFinalField[])$VALUES.clone();
        }

        public static NotEffectivelyFinalField valueOf(String name) {
            return Enum.valueOf(NotEffectivelyFinalField.class, name);
        }

        @Override
        @Nonnull
        public Marker cloneIfNeeded() {
            throw new AssertionError();
        }

        public static boolean checkIfCanBeFinalAndRemoveMarker(@Nonnull JField field) {
            return field.removeMarker(NotEffectivelyFinalField.class) == null;
        }

        public static boolean checkIfCanBeFinal(@Nonnull JField field) {
            return !field.containsMarker(NotEffectivelyFinalField.class);
        }

        public static void markAsNotFinal(@Nonnull JField field) {
            assert (!field.isVolatile() && !field.isFinal());
            field.addMarkerIfAbsent(NOT_EFFECTIVELY_FINAL);
        }

        static {
            $VALUES = new NotEffectivelyFinalField[]{NOT_EFFECTIVELY_FINAL};
        }
    }
}

