/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.common;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.optimizations.common.OptimizerUtils;
import com.android.sched.item.Component;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class LiteralValueTrackerBase {
    @Nonnull
    private static final JValueLiteral NON_LITERAL_OR_MULTIPLE_VALUE = new JValueLiteral(SourceInfo.UNKNOWN){

        @Override
        public boolean isTypeValue() {
            return false;
        }

        @Override
        public JType getType() {
            throw new AssertionError();
        }

        @Override
        public void traverse(@Nonnull JVisitor visitor) {
            throw new AssertionError();
        }

        @Override
        public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
            throw new AssertionError();
        }

        @Override
        public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
            throw new AssertionError();
        }
    };

    @Nonnull
    final JValueLiteral asLiteral(@Nonnull JExpression expression) {
        JValueLiteral result = OptimizerUtils.asLiteralOrDefault(expression, NON_LITERAL_OR_MULTIPLE_VALUE);
        assert (result != null);
        return result;
    }

    final boolean isMultipleOrNonLiteralValue(@CheckForNull JValueLiteral literal) {
        return literal == NON_LITERAL_OR_MULTIPLE_VALUE;
    }

    @Nonnull
    final JValueLiteral getMultipleOrNonLiteralValue() {
        return NON_LITERAL_OR_MULTIPLE_VALUE;
    }
}

