/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.common;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.optimizations.common.LiteralValueTrackerBase;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class LiteralValueListTracker
extends LiteralValueTrackerBase {
    public abstract int size();

    @CheckForNull
    abstract JValueLiteral getRawValue(@Nonnegative int var1);

    abstract void mergeWith(@Nonnegative int var1, @CheckForNull JValueLiteral var2);

    public boolean hasAtLeastOneLiteral() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.isMultipleOrNonLiteralValue(this.getRawValue(i))) continue;
            return true;
        }
        return false;
    }

    public final boolean isMultipleOrNonLiteralValue(@Nonnegative int arg) {
        return this.isMultipleOrNonLiteralValue(this.getRawValue(arg));
    }

    @CheckForNull
    public final JValueLiteral getConsolidatedValue(@Nonnegative int arg) {
        assert (!this.isMultipleOrNonLiteralValue(arg));
        return this.getRawValue(arg);
    }

    public final void updateWith(@Nonnull List<JExpression> args) {
        int size = this.size();
        assert (size == args.size());
        for (int i = 0; i < size; ++i) {
            this.mergeWith(i, this.asLiteral(args.get(i)));
        }
    }

    public final void updateWith(@Nonnull LiteralValueListTracker other) {
        int size = this.size();
        assert (size == other.size());
        for (int i = 0; i < size; ++i) {
            this.mergeWith(i, other.getRawValue(i));
        }
    }
}

