/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.common;

import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JEqOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JThrowStatement;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JPhantomLookup;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.ast.splitnew.SplitNewInstance;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Transform(add={JBlock.class, JEqOperation.class, JExpressionStatement.class, JIfStatement.class, JNullLiteral.class, JThrowStatement.class}, remove={JNewInstance.class})
@Use(value={LocalVarCreator.class, SplitNewInstance.NewExpressionSplitter.class})
public final class JlsNullabilityChecker {
    @Nonnull
    private final LocalVarCreator varCreator;
    @Nonnull
    private final JPhantomLookup getPhantomLookup;

    public JlsNullabilityChecker(@Nonnull LocalVarCreator varCreator, @Nonnull JPhantomLookup getPhantomLookup) {
        this.varCreator = varCreator;
        this.getPhantomLookup = getPhantomLookup;
    }

    @CheckForNull
    public JStatement createNullCheckIfNeeded(@Nonnull JExpression expr, @Nonnull TransformationRequest request) {
        return expr instanceof JThisRef ? null : this.createNullCheck(expr, request);
    }

    @Nonnull
    public JStatement createNullCheck(@Nonnull JExpression expr, @Nonnull TransformationRequest request) {
        SourceInfo srcInfo = expr.getSourceInfo();
        return new JIfStatement(srcInfo, new JEqOperation(srcInfo, expr, new JNullLiteral(srcInfo)), this.createThenBlock(srcInfo, request), null);
    }

    @Nonnull
    private JBlock createThenBlock(@Nonnull SourceInfo srcInfo, @Nonnull TransformationRequest request) {
        JClass exceptionType = this.getPhantomLookup.getClass(CommonTypes.JAVA_LANG_NULL_POINTER_EXCEPTION);
        JNewInstance newInstance = new JNewInstance(srcInfo, exceptionType, exceptionType.getOrCreateMethodIdWide("<init>", Collections.emptyList(), MethodKind.INSTANCE_NON_VIRTUAL));
        JExpression[] expressions = SplitNewInstance.NewExpressionSplitter.splitNewInstance(newInstance, request, this.varCreator);
        assert (expressions.length == 3);
        JBlock block = new JBlock(srcInfo);
        block.addStmt(new JExpressionStatement(srcInfo, expressions[0]));
        block.addStmt(new JExpressionStatement(srcInfo, expressions[1]));
        block.addStmt(new JThrowStatement(srcInfo, expressions[2]));
        return block;
    }
}

