/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.common;

import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.optimizations.common.ConcurrentLiteralValueTracker;
import com.android.jack.optimizations.common.LiteralValueListTracker;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ConcurrentLiteralValueListTracker
extends LiteralValueListTracker {
    @Nonnull
    private final ConcurrentLiteralValueTracker[] values;

    public ConcurrentLiteralValueListTracker(@Nonnegative int size) {
        this.values = new ConcurrentLiteralValueTracker[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = new ConcurrentLiteralValueTracker();
        }
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    @CheckForNull
    JValueLiteral getRawValue(@Nonnegative int index) {
        return this.values[index].getRawValue();
    }

    @Override
    void mergeWith(@Nonnegative int index, @CheckForNull JValueLiteral literal) {
        if (literal != null) {
            this.values[index].markExpression(literal);
        }
    }
}

