/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.CompoundAssignment;
import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JAndOperation;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBinaryOperator;
import com.android.jack.ir.ast.JBitAndOperation;
import com.android.jack.ir.ast.JBitOrOperation;
import com.android.jack.ir.ast.JEqOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JGtOperation;
import com.android.jack.ir.ast.JGteOperation;
import com.android.jack.ir.ast.JLtOperation;
import com.android.jack.ir.ast.JLteOperation;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNeqOperation;
import com.android.jack.ir.ast.JOrOperation;
import com.android.jack.ir.ast.JPrefixNotOperation;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JUnaryOperation;
import com.android.jack.ir.ast.JUnaryOperator;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.UnsupportedOperatorException;
import com.android.jack.ir.types.JFloatingPointType;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Simplify '!' operator when it is valuable")
@Constraint(need={JPrefixNotOperation.class}, no={ThreeAddressCodeForm.class, CompoundAssignment.class})
@Transform(add={JPrefixNotOperation.class, JGteOperation.class, JGtOperation.class, JLteOperation.class, JLtOperation.class, JEqOperation.class, JNeqOperation.class, JAndOperation.class, JOrOperation.class, JBitAndOperation.class, JBitOrOperation.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
public class NotSimplifier
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        NotSimplifierVisitor notRemover = new NotSimplifierVisitor(method);
        notRemover.accept(method);
    }

    private static class NotSimplifierVisitor
    extends JVisitor {
        @Nonnull
        private final JMethod method;

        public NotSimplifierVisitor(@Nonnull JMethod method) {
            this.method = method;
        }

        @Override
        public boolean visit(@Nonnull JUnaryOperation unaryOp) {
            boolean deep = true;
            if (unaryOp.getOp() == JUnaryOperator.NOT) {
                CountOperatorAfterRemoval countOp = new CountOperatorAfterRemoval();
                countOp.accept(unaryOp.getArg());
                if (countOp.opAfterTransformation < countOp.opBeforeTransformation) {
                    TransformationRequest tr = new TransformationRequest(this.method);
                    tr.append(new Replace(unaryOp, unaryOp.getArg()));
                    ReverseNotExpression reverse = new ReverseNotExpression(tr);
                    reverse.accept(unaryOp.getArg());
                    tr.commit();
                    deep = false;
                }
            }
            return deep;
        }
    }

    private static class ReverseNotExpression
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;

        public ReverseNotExpression(@Nonnull TransformationRequest tr) {
            this.tr = tr;
        }

        @Override
        public boolean visit(@Nonnull JExpression expr) {
            assert (expr.getType() instanceof JPrimitiveType.JBooleanType || expr.getType().isSameType(Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_BOOLEAN)));
            this.tr.append(new Replace(expr, new JPrefixNotOperation(expr.getSourceInfo(), expr)));
            return false;
        }

        @Override
        public boolean visit(@Nonnull JBinaryOperation binaryOp) {
            assert (binaryOp.getType() instanceof JPrimitiveType.JBooleanType || binaryOp.getType().isSameType(Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_BOOLEAN)));
            JBinaryOperator op = binaryOp.getOp();
            assert (op.isComparison() || op.isConditionalOperation() || op == JBinaryOperator.BIT_AND || op == JBinaryOperator.BIT_OR || op == JBinaryOperator.BIT_XOR);
            try {
                this.tr.append(new Replace(binaryOp, JBinaryOperation.create(binaryOp.getSourceInfo(), binaryOp.getOp().getReverseOperator(), binaryOp.getLhs(), binaryOp.getRhs())));
            }
            catch (UnsupportedOperatorException e) {
                throw new JNodeInternalError("Failures into not simplifier", e);
            }
            return binaryOp.getOp().isConditionalOperation() || op == JBinaryOperator.BIT_AND || op == JBinaryOperator.BIT_OR;
        }

        @Override
        public boolean visit(@Nonnull JUnaryOperation unaryOp) {
            assert (unaryOp.getOp() == JUnaryOperator.NOT);
            this.tr.append(new Replace(unaryOp, unaryOp.getArg()));
            return false;
        }
    }

    private static class CountOperatorAfterRemoval
    extends JVisitor {
        @Nonnegative
        private int opBeforeTransformation = 1;
        @Nonnegative
        private int opAfterTransformation = 0;

        private CountOperatorAfterRemoval() {
        }

        @Override
        public boolean visit(@Nonnull JExpression expr) {
            assert (expr.getType() instanceof JPrimitiveType.JBooleanType || expr.getType().isSameType(Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_BOOLEAN)));
            ++this.opAfterTransformation;
            return false;
        }

        @Override
        public boolean visit(@Nonnull JBinaryOperation binaryOp) {
            assert (binaryOp.getType() instanceof JPrimitiveType.JBooleanType || binaryOp.getType().isSameType(Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_BOOLEAN)));
            ++this.opBeforeTransformation;
            JBinaryOperator op = binaryOp.getOp();
            if (op.isComparison() && !this.useFloatingTypes(binaryOp) || op.isConditionalOperation() || op == JBinaryOperator.BIT_AND || op == JBinaryOperator.BIT_OR) {
                ++this.opAfterTransformation;
            } else {
                assert (op == JBinaryOperator.ASG || op == JBinaryOperator.BIT_XOR || op.isComparison() && this.useFloatingTypes(binaryOp));
                this.opAfterTransformation += 2;
            }
            return binaryOp.getOp().isConditionalOperation() || op == JBinaryOperator.BIT_AND || op == JBinaryOperator.BIT_OR;
        }

        @Override
        public boolean visit(@Nonnull JUnaryOperation unaryOp) {
            assert (unaryOp.getOp() == JUnaryOperator.NOT);
            ++this.opBeforeTransformation;
            return false;
        }

        private boolean useFloatingTypes(@Nonnull JBinaryOperation binaryOp) {
            return binaryOp.getLhs().getType() instanceof JFloatingPointType || binaryOp.getRhs().getType() instanceof JFloatingPointType;
        }
    }
}

