/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations;

import com.android.jack.Options;
import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.analysis.UsedVariableMarker;
import com.android.jack.analysis.dfa.reachingdefs.ReachingDefsMarker;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.google.common.collect.Lists;
import com.android.jack.google.common.collect.Maps;
import com.android.jack.google.common.collect.Sets;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.optimizations.DefUsesAndUseDefsChainsSimplifier;
import com.android.jack.optimizations.Optimizations;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.ControlFlowHelper;
import com.android.jack.util.OptimizationTools;
import com.android.jack.util.ThreeAddressCodeFormUtils;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Simplify definition uses chains.")
@Constraint(need={DefinitionMarker.class, UseDefsMarker.class, ThreeAddressCodeForm.class, ControlFlowGraph.class, UsedVariableMarker.class})
@Transform(remove={ReachingDefsMarker.class})
@Support(value={Optimizations.DefUseSimplifier.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class DefUsesChainsSimplifier
extends DefUsesAndUseDefsChainsSimplifier
implements RunnableSchedulable<JMethod> {
    @Nonnull
    public static final StatisticId<Counter> SIMPLIFIED_DEF_USE = new StatisticId<Counter>("jack.optimization.defuse", "Def use chain simplified", CounterImpl.class, Counter.class);
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Nonnull
    private static LinkedHashMap<JVariable, VarInfo> collectDefinitions(@Nonnull ControlFlowGraph cfg) {
        LinkedHashMap<JVariable, VarInfo> defs = Maps.newLinkedHashMap();
        for (BasicBlock bb : cfg.getNodes()) {
            for (JStatement stmt : bb.getStatements()) {
                DefinitionMarker dm = ThreeAddressCodeFormUtils.getDefinitionMarker(stmt);
                if (dm != null) {
                    JVariable variable = dm.getDefinedVariable();
                    VarInfo info = defs.get(variable);
                    if (info == null) {
                        info = new VarInfo(variable);
                        defs.put(variable, info);
                    }
                    info.defs.add(dm);
                }
                for (JVariableRef ref : OptimizationTools.getUsedVariables(stmt)) {
                    JVariable variable = ref.getTarget();
                    VarInfo info = defs.get(variable);
                    if (info == null) {
                        info = new VarInfo(variable);
                        defs.put(variable, info);
                    }
                    info.refStmts.add(stmt);
                }
            }
        }
        return defs;
    }

    @Nonnull
    private static LinkedHashMap<JVariable, OptInfo> collectCandidates(@Nonnull LinkedHashMap<JVariable, VarInfo> definitions) {
        LinkedHashMap<JVariable, OptInfo> result = Maps.newLinkedHashMap();
        for (Map.Entry<JVariable, VarInfo> info : definitions.entrySet()) {
            OptInfo opt = DefUsesChainsSimplifier.considerCandidate(info.getValue());
            if (opt == null) continue;
            result.put(opt.aVarInfo.var, opt);
        }
        return result;
    }

    @CheckForNull
    private static OptInfo considerCandidate(@Nonnull VarInfo info) {
        if (!info.var.isSynthetic()) {
            return null;
        }
        if (info.refStmts.size() != 1) {
            return null;
        }
        JStatement stmt = info.refStmts.get(0);
        if (!(stmt instanceof JExpressionStatement)) {
            return null;
        }
        JExpression assignment = ((JExpressionStatement)stmt).getExpr();
        if (!(assignment instanceof JAsgOperation)) {
            return null;
        }
        for (DefinitionMarker aDef : info.defs) {
            List<JVariableRef> aRefs = aDef.getUses();
            if (aRefs.size() != 1 || assignment == aRefs.get(0).getParent()) continue;
            return null;
        }
        DefinitionMarker bDef = assignment.getMarker(DefinitionMarker.class);
        if (bDef == null || !bDef.hasValue()) {
            return null;
        }
        JExpression valueExpr = bDef.getValue();
        if (!(valueExpr instanceof JVariableRef) || ((JVariableRef)valueExpr).getTarget() != info.var) {
            return null;
        }
        return new OptInfo(info, bDef);
    }

    private void processCandidate(@Nonnull JMethod method, @Nonnull ControlFlowGraph cfg, @Nonnull LinkedHashMap<JVariable, VarInfo> definitions, @Nonnull OptInfo info) {
        DefinitionMarker bDef = info.bDefinition;
        JVariable bVariable = bDef.getDefinedVariable();
        CfgHelper helper = new CfgHelper(cfg, info.aVarInfo.var, bVariable);
        JStatement s0 = bDef.getStatement();
        assert (s0 != null);
        assert (definitions.containsKey(info.bDefinition.getDefinedVariable()));
        if (helper.isCondition1or2Violated(s0)) {
            return;
        }
        VarInfo bVarInfo = definitions.get(bVariable);
        if (helper.isCondition4Violated(bVarInfo.refStmts)) {
            return;
        }
        this.tracer.getStatistic(SIMPLIFIED_DEF_USE).incValue();
        TransformationRequest tr = new TransformationRequest(method);
        for (DefinitionMarker aDef : info.aVarInfo.defs) {
            JVariableRef bRefNew = this.getNewVarRef(bDef.getDefinedExpr(), aDef.getDefinedExpr().getSourceInfo());
            tr.append(new Replace(aDef.getDefinedExpr(), bRefNew));
            aDef.resetDefinedVariable(bVariable);
            aDef.removeAllUses();
            for (JVariableRef bDefUse : bDef.getUses()) {
                aDef.addUse(bDefUse);
            }
        }
        bDef.removeAllUses();
        bVarInfo.mergeWith(definitions.get(info.aVarInfo.var));
        bVarInfo.defs.remove(bDef);
        definitions.remove(info.aVarInfo.var);
        tr.append(new Remove(s0));
        tr.commit();
    }

    private void processCandidatesWithDependencies(@Nonnull JMethod method, @Nonnull ControlFlowGraph cfg, @Nonnull LinkedHashMap<JVariable, OptInfo> candidates, @Nonnull LinkedHashMap<JVariable, VarInfo> definitions) {
        Set<OptInfo> queued = Sets.newIdentityHashSet();
        for (Map.Entry<JVariable, OptInfo> entry : candidates.entrySet()) {
            this.processCandidateWithDependencies(method, cfg, entry.getValue(), candidates, definitions, queued);
        }
    }

    private void processCandidateWithDependencies(@Nonnull JMethod method, @Nonnull ControlFlowGraph cfg, @Nonnull OptInfo candidate, @Nonnull LinkedHashMap<JVariable, OptInfo> candidates, @Nonnull LinkedHashMap<JVariable, VarInfo> definitions, @Nonnull Set<OptInfo> queued) {
        if (queued.contains(candidate)) {
            return;
        }
        queued.add(candidate);
        JVariable bVar = candidate.bDefinition.getDefinedVariable();
        if (candidates.containsKey(bVar)) {
            this.processCandidateWithDependencies(method, cfg, candidates.get(bVar), candidates, definitions, queued);
        }
        this.processCandidate(method, cfg, definitions, candidate);
    }

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        ControlFlowGraph cfg = method.getMarker(ControlFlowGraph.class);
        assert (cfg != null);
        LinkedHashMap<JVariable, VarInfo> definitions = DefUsesChainsSimplifier.collectDefinitions(cfg);
        LinkedHashMap<JVariable, OptInfo> candidates = DefUsesChainsSimplifier.collectCandidates(definitions);
        this.processCandidatesWithDependencies(method, cfg, candidates, definitions);
        method.removeMarker(ReachingDefsMarker.class);
    }

    private static final class CfgHelper {
        private static final byte BB_NOT_CHECKED_YET = 0;
        private static final byte BB_ACCESSES_NONE = 1;
        private static final byte BB_ASSIGNS_OR_READS_B = 2;
        private static final byte BB_ASSIGNS_A = 4;
        private static final byte BB_ENTRY_POINT = 8;
        private final ControlFlowGraph cfg;
        private final byte[] flags;
        private final JVariable aVar;
        private final JVariable bVar;

        CfgHelper(@Nonnull ControlFlowGraph cfg, @Nonnull JVariable aVar, @Nonnull JVariable bVar) {
            this.cfg = cfg;
            this.aVar = aVar;
            this.bVar = bVar;
            this.flags = new byte[cfg.getBasicBlockMaxId()];
        }

        boolean isCondition1or2Violated(@Nonnull JStatement startStmt) {
            return this.traverse(Lists.newArrayList(startStmt), (byte)10, (byte)4);
        }

        boolean isCondition4Violated(@Nonnull List<JStatement> startStmts) {
            return this.traverse(startStmts, (byte)4, (byte)2);
        }

        private boolean traverse(@Nonnull List<JStatement> startStmts, byte violatingFlags, byte ignorePredecessorFlags) {
            boolean[] queued = new boolean[this.flags.length];
            LinkedList<BasicBlock> queue = new LinkedList<BasicBlock>();
            for (JStatement stmt : startStmts) {
                BasicBlock bb = ControlFlowHelper.getBasicBlock(stmt);
                if (!this.process(bb, stmt, violatingFlags, ignorePredecessorFlags, queue, queued)) continue;
                return true;
            }
            while (!queue.isEmpty()) {
                BasicBlock bb = (BasicBlock)queue.removeFirst();
                if (!this.process(bb, null, violatingFlags, ignorePredecessorFlags, queue, queued)) continue;
                return true;
            }
            return false;
        }

        private boolean process(@Nonnull BasicBlock bb, @CheckForNull JStatement stmt, byte violatingFlags, byte ignorePredecessorFlags, @Nonnull LinkedList<BasicBlock> queue, @Nonnull boolean[] queued) {
            byte bbFlag;
            byte by = bbFlag = stmt != null ? this.computeBasicBlockFlag(bb, stmt) : this.getBasicBlockFlag(bb);
            assert (bbFlag != 0);
            if ((violatingFlags & bbFlag) != 0) {
                return true;
            }
            if ((ignorePredecessorFlags & bbFlag) == 0) {
                for (BasicBlock bbPredecessor : bb.getPredecessors()) {
                    int id = bbPredecessor.getId();
                    if (queued[id]) continue;
                    queue.addLast(bbPredecessor);
                    queued[id] = true;
                }
            }
            return false;
        }

        private byte getBasicBlockFlag(@Nonnull BasicBlock basicBlock) {
            int id = basicBlock.getId();
            byte flag = this.flags[id];
            if (flag == 0) {
                this.flags[id] = flag = this.computeBasicBlockFlag(basicBlock, null);
            }
            return flag;
        }

        private byte computeBasicBlockFlag(@Nonnull BasicBlock basicBlock, @CheckForNull JStatement upperLimit) {
            List<JStatement> statements = basicBlock.getStatements();
            for (int i = statements.size() - 1; i >= 0; --i) {
                JStatement stmt = statements.get(i);
                if (upperLimit != null) {
                    if (upperLimit != stmt) continue;
                    upperLimit = null;
                    continue;
                }
                DefinitionMarker dm = ThreeAddressCodeFormUtils.getDefinitionMarker(stmt);
                if (dm != null) {
                    JVariable variable = dm.getDefinedVariable();
                    if (variable == this.aVar) {
                        return 4;
                    }
                    if (variable == this.bVar) {
                        return 2;
                    }
                }
                List<JVariableRef> refs = OptimizationTools.getUsedVariables(stmt);
                for (JVariableRef ref : refs) {
                    if (ref.getTarget() != this.bVar) continue;
                    return 2;
                }
            }
            return this.cfg.getEntryNode() == basicBlock ? (byte)8 : 1;
        }
    }

    private static class VarInfo {
        @Nonnull
        final JVariable var;
        @Nonnull
        final Set<DefinitionMarker> defs = Sets.newIdentityHashSet();
        @Nonnull
        final List<JStatement> refStmts = new ArrayList<JStatement>();

        VarInfo(@Nonnull JVariable var) {
            this.var = var;
        }

        void mergeWith(@Nonnull VarInfo other) {
            this.defs.addAll(other.defs);
            assert (other.refStmts.size() == 1);
        }
    }

    private static class OptInfo {
        @Nonnull
        final VarInfo aVarInfo;
        @Nonnull
        final DefinitionMarker bDefinition;

        private OptInfo(@Nonnull VarInfo aVarInfo, @Nonnull DefinitionMarker bDefinition) {
            this.aVarInfo = aVarInfo;
            this.bDefinition = bDefinition;
        }
    }
}

