/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.library;

import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.library.LibraryIOException;
import com.android.jack.library.LibraryLocation;
import com.android.jack.library.OutputJackLibrary;
import com.android.jack.library.OutputJackLibraryCodec;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.ReportableException;
import com.android.jack.reporting.Reporter;
import com.android.sched.util.HasDescription;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.PropertyId;
import javax.annotation.Nonnull;

public class OutputJackLibraryPropertyId
extends PropertyId<OutputJackLibrary>
implements HasDescription {
    @Nonnull
    public static OutputJackLibraryPropertyId create(@Nonnull String name, @Nonnull String description) {
        return new OutputJackLibraryPropertyId(name, description, new OutputJackLibraryCodec());
    }

    protected OutputJackLibraryPropertyId(@Nonnull String name, @Nonnull String description, @Nonnull OutputJackLibraryCodec codec) {
        super(name, description, codec);
        this.setShutdownHook(new PropertyId.ShutdownRunnable<OutputJackLibrary>(){

            @Override
            public void run(@Nonnull OutputJackLibrary lib) {
                try {
                    lib.close();
                }
                catch (LibraryIOException e) {
                    CannotCloseOutputLibException reportable = new CannotCloseOutputLibException(lib, e);
                    Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
                    throw new JackAbortException(reportable);
                }
            }
        });
    }

    @Nonnull
    public OutputJackLibraryPropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public OutputJackLibraryPropertyId addDefaultValue(@Nonnull OutputJackLibrary defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public OutputJackLibraryPropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Nonnull
    public OutputJackLibraryPropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public OutputJackLibraryPropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }

    private static class CannotCloseOutputLibException
    extends ReportableException {
        private static final long serialVersionUID = 1L;

        public CannotCloseOutputLibException(@Nonnull OutputJackLibrary lib, @Nonnull LibraryIOException e) {
            super("Cannot close output Jack library " + ((LibraryLocation)lib.getLocation()).getDescription(), e);
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.ERROR;
        }
    }
}

